#include "_shared.fx"

Texture2D framebuffer;

struct VS_INPUT
{
    float3 vPos 	: POSITION;
	float2 uvCoord 	: TEXCOORD0;
};

struct VS_OUTPUT
{
    float4 Position	: SV_POSITION;
	float2 uvCoord	: TEXCOORD0;
};

struct PS_OUTPUT 
{
	float4 finalColor : SV_Target;
};

VS_OUTPUT RenderSceneQuadVS( VS_INPUT In )
{
    VS_OUTPUT Out;
    
    Out.Position = float4(In.vPos.x,In.vPos.y,0.1f,1.0f);
	Out.uvCoord = In.uvCoord;
	
    return Out;
}
PS_OUTPUT RenderSceneQuadPS( VS_OUTPUT In )
{ 
	PS_OUTPUT Out;

	float fac = saturate(exp(-10.0f*abs(framebuffer.Sample(LinearSampler,In.uvCoord).r-0.3f))-0.1f);
	
	Out.finalColor = float4(float3(0.6f,0.8f,0.9f),fac);
    return Out;
}
technique10 RenderScene
{
    pass P0
    {          
        SetVertexShader( CompileShader( vs_4_0, RenderSceneQuadVS() ) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, RenderSceneQuadPS() ) );
		
		SetDepthStencilState( NoDepth, 0 );
		SetBlendState( Blending, float4(0,0,0,0), 0xffffffff );
    }
}