#include "_shared.fx"

Texture2D image;
Texture2D<float2> offsets;
float startTime = 73.0f;

float4x4 wvpMatrix 	: WorldViewProjection;
float4x4 wvMatrix 	: WorldView;

struct VS_INPUT
{
    float3 vPos 	: POSITION;
	float2 uvCoord 	: TEXCOORD0;
	float3 extend	: TEXCOORD1;
};

struct VS_OUTPUT
{
    float4 Position	: SV_POSITION;
	float2 uvCoord	: TEXCOORD0;
	float  fac		: TEXCOORD1;
};

VS_OUTPUT RenderSceneVS( VS_INPUT In )
{
    VS_OUTPUT Out;
    
	float4 position = mul( float4(In.vPos,1.0f), wvMatrix );
	float angle = time+offsets.SampleLevel(PointSampler,float2(0.0f,In.extend.z*10.0f),0)*1000.0f;
	float2x2 rotMat = { cos(angle), -sin(angle), sin(angle), cos(angle) };
	
	position.xy += mul(rotMat,float2(In.extend.x,In.extend.y));
    Out.Position = mul(position, pMatrix);
	Out.uvCoord = In.uvCoord;
	Out.fac = saturate(time-startTime-In.extend.z*10.0f);
    return Out;
}


struct PS_OUTPUT 
{
	float4 finalColor : SV_Target;
};

PS_OUTPUT RenderScenePS( VS_OUTPUT In )
{ 
	PS_OUTPUT Out;

	float3 star = image.Sample(LinearSampler,In.uvCoord);
	Out.finalColor = float4(star.rgb,star.r)*In.fac;
    return Out;
}

technique10 RenderScene
{
    pass P0
    {          
        SetVertexShader( CompileShader( vs_4_0, RenderSceneVS() ) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, RenderScenePS() ) );
		
		SetDepthStencilState( DepthTest, 0 );
		SetRasterizerState( NotMultisampled );
		SetBlendState( Blending, float4(0,0,0,0), 0xffffffff );
    }
}