#include "_shared.fx"

float4 g_MaterialAmbientColor
<
    string UIName =  "Material Ambient";
    string UIWidget = "Color";
> = {0.2f,0.2f,0.2f,1.0f};

float4 g_MaterialDiffuseColor
<
    string UIName =  "Material Diffuse";
    string UIWidget = "Color";
> = { 1.0f, 1.0f, 1.0f, 0.0f };

float4x4 wMatrix 	: World
<
	string UIWidget="None";
>;

Texture2D<float4> image;

struct VS_INPUT
{
    float3 vPos : POSITION;
    float3 normal : NORMAL;
	float2 uvCoord : TEXCOORD0;
};

struct VS_OUTPUT
{
    float4 Position	: SV_POSITION;
    float3 lightDir	: TEXCOORD0;
    float3 normal	: TEXCOORD1;
	float2 uvCoord  : TEXCOORD2;
};


VS_OUTPUT RenderSceneVS( VS_INPUT In )
{
    VS_OUTPUT Out;
    
    Out.normal = mul( float4(In.normal,0.0f), wMatrix );
    float3 vWorld = mul( float4(In.vPos,1.0f), wMatrix );
    Out.lightDir = normalize(lightPos - vWorld.xyz);

	float4x4 wpMatrix = mul(wMatrix,pMatrix);
    Out.Position = mul(float4(In.vPos,1.0f), wpMatrix);
	Out.uvCoord = In.uvCoord;
	
    return Out;
}


struct PS_OUTPUT 
{
	float4 finalColor : SV_Target;
};

PS_OUTPUT RenderScenePS( VS_OUTPUT In )
{ 
	PS_OUTPUT Out;

	float3 normal = normalize( In.normal );
	float3 lightDir = normalize( In.lightDir );
	float dif = max( 0.0f, dot( normal, lightDir ) );
	float4 finalColor = g_MaterialDiffuseColor*dif + g_MaterialAmbientColor;
	Out.finalColor = pow( finalColor*image.SampleLevel(LinearSampler,In.uvCoord,0), 1/2.2f );

    	return Out;
}


technique10 RenderScene
{
    pass P0
    {          
        SetVertexShader( CompileShader( vs_4_0, RenderSceneVS() ) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, RenderScenePS() ) );
    }
}