#include "_shared.fx"

Texture2D<float4> image;

float4x4 wMatrix	: World;
float4x4 wvpMatrix 	: WorldViewProjection;
float ColA;

struct VS_INPUT
{
    float3 position : POSITION;
	float3 normal	: NORMAL;
	float3 uvCoord	: TEXCOORD1;
	uint freq		: TEXCOORD2;
};

struct VS_OUTPUT
{
    float4 position	: SV_POSITION;
	float4 color	: TEXCOORD0;
};


VS_OUTPUT RenderSceneVS( VS_INPUT In )
{
    VS_OUTPUT Out;
    
	float hit = -In.uvCoord.z;
	
	float dist = In.uvCoord.z+2.0f*time;
	float dist2 = dist-0.6f;
	float dist3 = dist2-0.9f;
	In.position.z += min(0.0f,dist) +min(dist2*dist2-0.36f,0.0f) +min(dist3*dist3-0.09f,0.0f);
	float3 normal = mul(In.normal,wMatrix);
	float3 position = mul(float4(In.position,1.0f),wMatrix);
	float3 toLight = normalize(lightPos-position);
	float dotP = max(0.4f,dot(normal,toLight));
    Out.position = mul(float4(In.position,1.0f), wvpMatrix);
	float amp = max(0.2f,saturate(fftData.Load( int3(In.freq,0,0) )*70.0f));
	float4 imgCol = float4(image.SampleLevel(LinearSampler,In.uvCoord,0).rgb*amp*dotP,ColA);
	Out.color = imgCol;
	
    return Out;
}


struct PS_OUTPUT 
{
	float4 finalColor : SV_Target;
};

PS_OUTPUT RenderScenePS( VS_OUTPUT In )
{ 
	PS_OUTPUT Out;
	Out.finalColor = In.color;
    return Out;
}


technique10 RenderScene
{
    pass P0
    {          
        SetVertexShader( CompileShader( vs_4_0, RenderSceneVS() ) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, RenderScenePS() ) );
		
		SetDepthStencilState( Depth, 0 );
		SetRasterizerState( Multisampled );
		SetBlendState( Blending, float4(0,0,0,0), 0xffffffff );
    }
}