#include "_shared.fx"

float4 g_MaterialAmbientColor = { 1.0f, 1.0f, 1.0f, 1.0f };
float4x4 wvpMatrix 	: WorldViewProjection;
Texture2D texture_0;
float ColA;

struct VS_INPUT
{
    float3 position : POSITION;
	float2 uvCoord	: TEXCOORD0;
};

struct VS_OUTPUT
{
    float4 position	: SV_POSITION;
	float2 uvCoord	: TEXCOORD0;
};


VS_OUTPUT RenderSceneVS( VS_INPUT In )
{
    VS_OUTPUT Out;
    
    Out.position = mul(float4(In.position,1.0f), wvpMatrix);
	Out.uvCoord = In.uvCoord;
	
    return Out;
}


struct PS_OUTPUT 
{
	float4 finalColor : SV_Target;
};

PS_OUTPUT RenderScenePS( VS_OUTPUT In )
{ 
	PS_OUTPUT Out;

	Out.finalColor = texture_0.Sample(LinearSampler,In.uvCoord)*g_MaterialAmbientColor*ColA;

    return Out;
}


technique10 RenderScene
{
    pass P0
    {          
        SetVertexShader( CompileShader( vs_4_0, RenderSceneVS() ) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, RenderScenePS() ) );
		
		SetDepthStencilState( Depth, 0 );
		SetBlendState( NoBlending, float4(0,0,0,0), 0xffffffff );
		SetRasterizerState( Multisampled );
    }
}