shared cbuffer perFrame
{
	float4x4 lvMatrix	: View
	<
		string Object = "PointLight0";
	>;
	float4x4 vpMatrix : ViewProjection;
	float3 cameraPos : Position
	<
		string Object = "ActiveCamera";
	>;
	
	float4x4 pMatrix : Projection;
	
	float4x4 pMatrices[3] : SplitProjection
	<
		string Object = "PointLight0";
		string UIWidget="None";
	>;
	float3 lightPos 	: Position
	<
		string Object = "PointLight0";
		string UIWidget = "None";
	> = { 0.0f, 0.0f, 0.0f };
	float time 			: Time
	<
		string UIWidget="None";
	>;
	float3	splitPlanes : SplitPlanes
	<
		string Object = "PointLight0";
		string UIWidget="None";
	>;
	float depthBias
	<
		string UIName = "Depth Bias";
		string UIWidget = "slider";
	> = -0.0020f;
}

shared Texture2D<float2> noiseTex;
shared Texture2D<float> fftData;
shared Texture2DArray<float> shadowmap;

shared SamplerState ShadowSampler
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Border; 
	AddressV = Border;
	AddressW = Border;
	BorderColor = float4(2.0f,2.0f,2.0f,2.0f);
};
shared SamplerState LinearSampler
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap; 
	AddressV = Wrap;
};
shared SamplerState PointSampler
{
    Filter = MIN_MAG_MIP_POINT;
    AddressU = Wrap; 
	AddressV = Wrap;
};
shared BlendState Blending
{
	BlendEnable[0] = TRUE;
	SrcBlend = src_alpha;
    DestBlend = inv_src_alpha;
    BlendOp = ADD;
	SrcBlendAlpha = src_alpha;
	DestBlendAlpha = inv_src_alpha;
	BlendOpAlpha = ADD;
};
shared BlendState AdditiveBlending
{
	BlendEnable[0] = TRUE;
	SrcBlend = one;
    DestBlend = one;
    BlendOp = ADD;
	SrcBlendAlpha = one;
	DestBlendAlpha = one;
	BlendOpAlpha = ADD;
};
shared BlendState NoBlending
{
	BlendEnable[0] = FALSE;
};
shared DepthStencilState NoDepth
{
	DepthEnable = false;
};
shared DepthStencilState DepthTest
{
	DepthEnable = true;
	DepthWriteMask = Zero;
};
shared DepthStencilState Depth
{
	DepthEnable = true;
	DepthWriteMask = All;
};
shared RasterizerState NotMultisampled
{
    MULTISAMPLEENABLE = FALSE;
	CULLMODE = Back;
};
shared RasterizerState Multisampled
{
    MULTISAMPLEENABLE = TRUE;
	CULLMODE = Back;
};