uniform sampler2D tu0;
uniform sampler2D tu1;
uniform sampler2D tu2;

uniform float t;
uniform float fade;


void main()
{
	vec4 res = texture2D( tu0, gl_TexCoord[0].st );

	vec4 ind0 = texture2D( tu0, res.st + gl_TexCoord[1].st ) ;
	vec4 ind1 = texture2D( tu1, res.tq - gl_TexCoord[2].st * vec2( 0.5 ) ) ;
	vec4 ind2 = texture2D( tu2, res.st - gl_TexCoord[1].st - vec2( 0.5 ) ) ;

	vec4 finalCol = ( ind0 + ind1 - ind2 ) * vec4( 0.75 );

	float distToMid = abs(gl_TexCoord[3].t - 0.5) * 3.0;
	float factor = finalCol.r - distToMid*distToMid - t*0.01;

	gl_FragColor = vec4( clamp( factor*20.0, 0.0, fade ) );
}
