uniform sampler2D normals;
uniform sampler2D tu0;
uniform sampler2D tu1;
uniform sampler2D tu2;

uniform float t;

void main()
{
	vec4 res = texture2D( tu0, gl_TexCoord[0].st );

	vec4 ind0 = texture2D( tu0, res.st + gl_TexCoord[1].st ) ;
	vec4 ind1 = texture2D( tu1, res.tq - gl_TexCoord[2].st * 0.5 ) ;
	vec4 ind2 = texture2D( tu2, res.st - gl_TexCoord[1].st - vec2( 0.5 ) ) ;

	vec3 n = (texture2D( normals, gl_TexCoord[0].st ).xyz * 2.0) - vec3( 1.0 );

	vec4 finalCol = vec4( ind0 + ind1 - ind2 ) * 0.75;
	vec4 mask = vec4( dot( n, normalize(gl_TexCoord[3].xyz) ) );

	gl_FragColor = finalCol * mask;
}
