/*
 * Decompiled with CFR 0.152.
 */
import java.nio.FloatBuffer;

class Matrix {
    float[] _M;

    Matrix() {
        this._M = new float[16];
        this.identity();
    }

    Matrix(Matrix matrix) {
        this.copy(matrix);
    }

    public void copy(Matrix matrix) {
        this._M[0] = matrix._M[0];
        this._M[4] = matrix._M[4];
        this._M[8] = matrix._M[8];
        this._M[12] = matrix._M[12];
        this._M[1] = matrix._M[1];
        this._M[5] = matrix._M[5];
        this._M[9] = matrix._M[9];
        this._M[13] = matrix._M[13];
        this._M[2] = matrix._M[2];
        this._M[6] = matrix._M[6];
        this._M[10] = matrix._M[10];
        this._M[14] = matrix._M[14];
        this._M[3] = matrix._M[3];
        this._M[7] = matrix._M[7];
        this._M[11] = matrix._M[11];
        this._M[15] = matrix._M[15];
    }

    public FloatBuffer getFloatBuffer() {
        FloatBuffer floatBuffer = FloatBuffer.wrap(this._M);
        return floatBuffer;
    }

    public void identity() {
        this._M[0] = 1.0f;
        this._M[4] = 0.0f;
        this._M[8] = 0.0f;
        this._M[12] = 0.0f;
        this._M[1] = 0.0f;
        this._M[5] = 1.0f;
        this._M[9] = 0.0f;
        this._M[13] = 0.0f;
        this._M[2] = 0.0f;
        this._M[6] = 0.0f;
        this._M[10] = 1.0f;
        this._M[14] = 0.0f;
        this._M[3] = 0.0f;
        this._M[7] = 0.0f;
        this._M[11] = 0.0f;
        this._M[15] = 1.0f;
    }

    public void scale(float f) {
        this._M[0] = this._M[0] * f;
        this._M[4] = 0.0f;
        this._M[8] = 0.0f;
        this._M[12] = 0.0f;
        this._M[1] = 0.0f;
        this._M[5] = this._M[5] * f;
        this._M[9] = 0.0f;
        this._M[13] = 0.0f;
        this._M[2] = 0.0f;
        this._M[6] = 0.0f;
        this._M[10] = this._M[10] * f;
        this._M[14] = 0.0f;
        this._M[3] = 0.0f;
        this._M[7] = 0.0f;
        this._M[11] = 0.0f;
        this._M[15] = 1.0f;
    }

    Matrix translate(float f, float f2, float f3) {
        Matrix matrix = new Matrix();
        matrix.identity();
        matrix._M[12] = f;
        matrix._M[13] = f2;
        matrix._M[14] = f3;
        return matrix;
    }

    void translate2(float f, float f2, float f3) {
        this._M[12] = f;
        this._M[13] = f2;
        this._M[14] = f3;
    }

    public void rotateX(float f) {
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        this._M[0] = 1.0f;
        this._M[4] = 0.0f;
        this._M[8] = 0.0f;
        this._M[12] = 0.0f;
        this._M[1] = 0.0f;
        this._M[5] = f2;
        this._M[9] = f3;
        this._M[13] = 0.0f;
        this._M[2] = 0.0f;
        this._M[6] = -f3;
        this._M[10] = f2;
        this._M[14] = 0.0f;
        this._M[3] = 0.0f;
        this._M[7] = 0.0f;
        this._M[11] = 0.0f;
        this._M[15] = 1.0f;
    }

    public void rotateY(float f) {
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        this._M[0] = f2;
        this._M[4] = 0.0f;
        this._M[8] = f3;
        this._M[12] = 0.0f;
        this._M[1] = 0.0f;
        this._M[5] = 1.0f;
        this._M[9] = 0.0f;
        this._M[13] = 0.0f;
        this._M[2] = -f3;
        this._M[6] = 0.0f;
        this._M[10] = f2;
        this._M[14] = 0.0f;
        this._M[3] = 0.0f;
        this._M[7] = 0.0f;
        this._M[11] = 0.0f;
        this._M[15] = 1.0f;
    }

    public void rotateZ(float f) {
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        this._M[0] = f2;
        this._M[4] = -f3;
        this._M[8] = 0.0f;
        this._M[12] = 0.0f;
        this._M[1] = f3;
        this._M[5] = f2;
        this._M[9] = 0.0f;
        this._M[13] = 0.0f;
        this._M[2] = 0.0f;
        this._M[6] = 0.0f;
        this._M[10] = 0.0f;
        this._M[14] = 0.0f;
        this._M[3] = 0.0f;
        this._M[7] = 0.0f;
        this._M[11] = 0.0f;
        this._M[15] = 1.0f;
    }

    Matrix rotate(float f, float f2, float f3) {
        Matrix matrix = new Matrix();
        float f4 = (float)Math.sin(f);
        float f5 = (float)Math.cos(f);
        float f6 = (float)Math.sin(f2);
        float f7 = (float)Math.cos(f2);
        float f8 = (float)Math.sin(f3);
        float f9 = (float)Math.cos(f3);
        float f10 = f5 * f9 + f4 * f6 * f8;
        float f11 = f8 * f7;
        float f12 = f5 * f6 * f8 - f4 * f9;
        float f13 = f4 * f6 * f9 - f5 * f8;
        float f14 = f9 * f7;
        float f15 = f8 * f4 + f9 * f5 * f6;
        float f16 = f7 * f4;
        float f17 = -f6;
        float f18 = f7 * f5;
        matrix._M[0] = f10;
        matrix._M[1] = f11;
        matrix._M[2] = f12;
        matrix._M[3] = 0.0f;
        matrix._M[4] = f13;
        matrix._M[5] = f14;
        matrix._M[6] = f15;
        matrix._M[7] = 0.0f;
        matrix._M[8] = f16;
        matrix._M[9] = f17;
        matrix._M[10] = f18;
        matrix._M[11] = 0.0f;
        matrix._M[12] = 0.0f;
        matrix._M[13] = 0.0f;
        matrix._M[14] = 0.0f;
        matrix._M[15] = 1.0f;
        return matrix;
    }

    public void add(Matrix matrix) {
        this._M[0] = this._M[0] + matrix._M[0];
        this._M[4] = this._M[4] + matrix._M[1];
        this._M[8] = this._M[8] + matrix._M[2];
        this._M[12] = this._M[12] + matrix._M[3];
        this._M[1] = this._M[1] + matrix._M[4];
        this._M[5] = this._M[5] + matrix._M[5];
        this._M[9] = this._M[9] + matrix._M[6];
        this._M[13] = this._M[13] + matrix._M[7];
        this._M[2] = this._M[2] + matrix._M[8];
        this._M[6] = this._M[6] + matrix._M[9];
        this._M[10] = this._M[10] + matrix._M[10];
        this._M[14] = this._M[14] + matrix._M[11];
        this._M[3] = this._M[3] + matrix._M[12];
        this._M[7] = this._M[7] + matrix._M[13];
        this._M[11] = this._M[11] + matrix._M[14];
        this._M[15] = this._M[15] + matrix._M[15];
    }

    Matrix mul(Matrix matrix) {
        Matrix matrix2 = new Matrix();
        matrix2._M[0] = this._M[0] * matrix._M[0] + this._M[4] * matrix._M[1] + this._M[8] * matrix._M[2] + this._M[12] * matrix._M[3];
        matrix2._M[1] = this._M[0] * matrix._M[4] + this._M[4] * matrix._M[5] + this._M[8] * matrix._M[6] + this._M[12] * matrix._M[7];
        matrix2._M[2] = this._M[0] * matrix._M[8] + this._M[4] * matrix._M[9] + this._M[8] * matrix._M[10] + this._M[12] * matrix._M[11];
        matrix2._M[3] = this._M[0] * matrix._M[12] + this._M[4] * matrix._M[13] + this._M[8] * matrix._M[15] + this._M[12] * matrix._M[15];
        matrix2._M[4] = this._M[1] * matrix._M[0] + this._M[5] * matrix._M[1] + this._M[9] * matrix._M[2] + this._M[13] * matrix._M[3];
        matrix2._M[5] = this._M[1] * matrix._M[4] + this._M[5] * matrix._M[5] + this._M[9] * matrix._M[6] + this._M[13] * matrix._M[7];
        matrix2._M[6] = this._M[1] * matrix._M[8] + this._M[5] * matrix._M[9] + this._M[9] * matrix._M[10] + this._M[13] * matrix._M[11];
        matrix2._M[7] = this._M[1] * matrix._M[12] + this._M[5] * matrix._M[13] + this._M[9] * matrix._M[15] + this._M[13] * matrix._M[15];
        matrix2._M[8] = this._M[2] * matrix._M[0] + this._M[6] * matrix._M[1] + this._M[10] * matrix._M[2] + this._M[14] * matrix._M[3];
        matrix2._M[9] = this._M[2] * matrix._M[4] + this._M[6] * matrix._M[5] + this._M[10] * matrix._M[6] + this._M[14] * matrix._M[7];
        matrix2._M[10] = this._M[2] * matrix._M[8] + this._M[6] * matrix._M[9] + this._M[10] * matrix._M[10] + this._M[14] * matrix._M[11];
        matrix2._M[11] = this._M[2] * matrix._M[12] + this._M[6] * matrix._M[13] + this._M[10] * matrix._M[15] + this._M[14] * matrix._M[15];
        matrix2._M[12] = this._M[3] * matrix._M[0] + this._M[7] * matrix._M[1] + this._M[11] * matrix._M[2] + this._M[15] * matrix._M[3];
        matrix2._M[13] = this._M[3] * matrix._M[4] + this._M[7] * matrix._M[5] + this._M[11] * matrix._M[6] + this._M[15] * matrix._M[7];
        matrix2._M[14] = this._M[3] * matrix._M[8] + this._M[7] * matrix._M[9] + this._M[11] * matrix._M[10] + this._M[15] * matrix._M[11];
        matrix2._M[15] = this._M[3] * matrix._M[12] + this._M[7] * matrix._M[13] + this._M[11] * matrix._M[15] + this._M[15] * matrix._M[15];
        return matrix2;
    }

    Matrix mul2(Matrix matrix) {
        Matrix matrix2 = new Matrix();
        matrix2._M[0] = this._M[0] * matrix._M[0] + this._M[1] * matrix._M[4] + this._M[2] * matrix._M[8] + this._M[3] * matrix._M[12];
        matrix2._M[1] = this._M[0] * matrix._M[1] + this._M[1] * matrix._M[5] + this._M[2] * matrix._M[9] + this._M[3] * matrix._M[13];
        matrix2._M[2] = this._M[0] * matrix._M[2] + this._M[1] * matrix._M[6] + this._M[2] * matrix._M[10] + this._M[3] * matrix._M[14];
        matrix2._M[3] = this._M[0] * matrix._M[3] + this._M[1] * matrix._M[7] + this._M[2] * matrix._M[11] + this._M[3] * matrix._M[15];
        matrix2._M[4] = this._M[4] * matrix._M[0] + this._M[5] * matrix._M[4] + this._M[6] * matrix._M[8] + this._M[7] * matrix._M[12];
        matrix2._M[5] = this._M[4] * matrix._M[1] + this._M[5] * matrix._M[5] + this._M[6] * matrix._M[9] + this._M[7] * matrix._M[13];
        matrix2._M[6] = this._M[4] * matrix._M[2] + this._M[5] * matrix._M[6] + this._M[6] * matrix._M[10] + this._M[7] * matrix._M[14];
        matrix2._M[7] = this._M[4] * matrix._M[3] + this._M[5] * matrix._M[7] + this._M[6] * matrix._M[11] + this._M[7] * matrix._M[15];
        matrix2._M[8] = this._M[8] * matrix._M[0] + this._M[9] * matrix._M[4] + this._M[10] * matrix._M[8] + this._M[11] * matrix._M[12];
        matrix2._M[9] = this._M[8] * matrix._M[1] + this._M[9] * matrix._M[5] + this._M[10] * matrix._M[9] + this._M[11] * matrix._M[13];
        matrix2._M[10] = this._M[8] * matrix._M[2] + this._M[9] * matrix._M[6] + this._M[10] * matrix._M[10] + this._M[11] * matrix._M[14];
        matrix2._M[11] = this._M[8] * matrix._M[3] + this._M[9] * matrix._M[7] + this._M[10] * matrix._M[11] + this._M[11] * matrix._M[15];
        matrix2._M[12] = this._M[12] * matrix._M[0] + this._M[13] * matrix._M[4] + this._M[14] * matrix._M[8] + this._M[15] * matrix._M[12];
        matrix2._M[13] = this._M[12] * matrix._M[1] + this._M[13] * matrix._M[5] + this._M[14] * matrix._M[9] + this._M[15] * matrix._M[13];
        matrix2._M[14] = this._M[12] * matrix._M[2] + this._M[13] * matrix._M[6] + this._M[14] * matrix._M[10] + this._M[15] * matrix._M[14];
        matrix2._M[15] = this._M[12] * matrix._M[3] + this._M[13] * matrix._M[7] + this._M[14] * matrix._M[11] + this._M[15] * matrix._M[15];
        return matrix2;
    }

    public void mul(float f) {
        this._M[0] = this._M[0] * f;
        this._M[4] = this._M[4] * f;
        this._M[8] = this._M[8] * f;
        this._M[12] = this._M[12] * f;
        this._M[1] = this._M[1] * f;
        this._M[5] = this._M[5] * f;
        this._M[9] = this._M[9] * f;
        this._M[13] = this._M[13] * f;
        this._M[2] = this._M[2] * f;
        this._M[6] = this._M[6] * f;
        this._M[10] = this._M[10] * f;
        this._M[14] = this._M[14] * f;
        this._M[3] = this._M[3] * f;
        this._M[7] = this._M[7] * f;
        this._M[11] = this._M[11] * f;
        this._M[15] = this._M[15] * f;
    }

    public void transpose() {
        Matrix matrix = new Matrix();
        matrix.copy(this);
        this._M[0] = matrix._M[0];
        this._M[4] = matrix._M[1];
        this._M[8] = matrix._M[2];
        this._M[12] = matrix._M[3];
        this._M[1] = matrix._M[4];
        this._M[5] = matrix._M[5];
        this._M[9] = matrix._M[6];
        this._M[13] = matrix._M[7];
        this._M[2] = matrix._M[8];
        this._M[6] = matrix._M[9];
        this._M[10] = matrix._M[10];
        this._M[14] = matrix._M[11];
        this._M[3] = matrix._M[12];
        this._M[7] = matrix._M[13];
        this._M[11] = matrix._M[14];
        this._M[15] = matrix._M[15];
    }

    public Vector3 transform(Vector3 vector3) {
        float f = vector3.x * this._M[0] + vector3.y * this._M[4] + vector3.z * this._M[8] + this._M[12];
        float f2 = vector3.x * this._M[1] + vector3.y * this._M[5] + vector3.z * this._M[9] + this._M[13];
        float f3 = vector3.x * this._M[2] + vector3.y * this._M[6] + vector3.z * this._M[10] + this._M[14];
        return new Vector3(f, f2, f3);
    }

    public static Vector3 transform(Vector3 vector3, float[] fArray) {
        float f = vector3.x * fArray[0] + vector3.y * fArray[4] + vector3.z * fArray[8] + fArray[12];
        float f2 = vector3.x * fArray[1] + vector3.y * fArray[5] + vector3.z * fArray[9] + fArray[13];
        float f3 = vector3.x * fArray[2] + vector3.y * fArray[6] + vector3.z * fArray[10] + fArray[14];
        return new Vector3(f, f2, f3);
    }
}

