/*
 * Decompiled with CFR 0.152.
 */
package fullscreen;

import java.awt.Color;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import processing.core.PApplet;
import processing.core.fullscreen_texturehelper;

public class FullScreen {
    Frame fsFrame = new Frame();
    GraphicsDevice fsDevice = this.fsFrame.getGraphicsConfiguration().getDevice();
    int fsResolutionX;
    int fsResolutionY;
    boolean fsIsInitialized;
    PApplet dad;
    static final int fsControlKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    static KeyEvent lastEvent = null;

    public FullScreen(PApplet dad) {
        if (dad.g.getClass().getName().equals("processing.opengl.PGraphicsOpenGL")) {
            System.err.println("FullScreen API: Warning, OPENGL Support is experimental! ");
            System.err.println("Keep checking http://www.superduper.org/processing/fullscreen_api/ for updates!");
        }
        this.dad = dad;
        dad.registerKeyEvent((Object)this);
        dad.frame.addKeyListener(new FSKeyListener(this));
        if (dad.width > 0) {
            this.setResolution(dad.width, dad.height);
        }
        this.fsFrame.setTitle("FullScreen");
        this.fsFrame.setUndecorated(true);
        ((Component)this.fsFrame).setBackground(Color.black);
        this.fsFrame.setLayout(null);
        this.fsFrame.addWindowListener(new FSWindowListener());
        ((Component)this.fsFrame).setSize(this.fsDevice.getDisplayMode().getWidth(), this.fsDevice.getDisplayMode().getHeight());
        this.fsFrame.addKeyListener(new FSKeyListener(this));
    }

    boolean isFullScreen() {
        return this.fsDevice.getFullScreenWindow() == this.fsFrame;
    }

    public boolean available() {
        return this.dad.frame != null;
    }

    public boolean enter() {
        return this.setFullScreen(true);
    }

    public boolean leave() {
        return this.setFullScreen(false);
    }

    public boolean setFullScreen(boolean fullScreen) {
        if (this.dad.frameCount == 0 && fullScreen) {
            new FSWaitForInitThread().start();
            return true;
        }
        if (fullScreen == this.isFullScreen()) {
            return true;
        }
        if (fullScreen) {
            if (this.available()) {
                this.fsDevice.setFullScreenWindow(this.fsFrame);
                this.dad.frame.removeAll();
                ((Component)this.dad.frame).setVisible(false);
                ((Component)this.dad.frame).setSize(this.dad.width + this.dad.frame.insets().left + this.dad.frame.insets().right, this.dad.height + this.dad.frame.insets().top + this.dad.frame.insets().bottom);
                this.fsFrame.add((Component)this.dad);
                this.dad.requestFocus();
                this.setResolution(0, 0);
                fullscreen_texturehelper.update(this.dad);
                return true;
            }
            System.err.println("FullScreen API: Fullscreen mode not available");
            return false;
        }
        this.fsFrame.removeAll();
        this.dad.frame.add((Component)this.dad);
        this.dad.setLocation(this.dad.frame.insets().left, this.dad.frame.insets().top);
        this.dad.requestFocus();
        this.fsDevice.setFullScreenWindow(null);
        ((Component)this.fsFrame).setVisible(false);
        ((Component)this.dad.frame).setVisible(true);
        fullscreen_texturehelper.update(this.dad);
        return true;
    }

    public boolean setResolution(int xRes, int yRes) {
        if (xRes > 0 && yRes > 0) {
            this.fsResolutionX = xRes;
            this.fsResolutionY = yRes;
        }
        if (!this.isFullScreen()) {
            return false;
        }
        if (this.fsResolutionX <= 0 || this.fsResolutionY <= 0) {
            this.dad.setLocation((this.fsDevice.getDisplayMode().getWidth() - this.dad.width) / 2, (this.fsDevice.getDisplayMode().getHeight() - this.dad.height) / 2);
            return false;
        }
        DisplayMode[] modes = this.fsDevice.getDisplayModes();
        DisplayMode theMode = null;
        int i = 0;
        while (i < modes.length) {
            if (modes[i].getWidth() == this.fsResolutionX && modes[i].getHeight() == this.fsResolutionY) {
                theMode = modes[i];
            }
            ++i;
        }
        if (theMode == null) {
            System.err.println("FullScreen API: Display mode not supported: " + this.fsResolutionX + "x" + this.fsResolutionY);
            this.dad.setLocation((this.fsDevice.getDisplayMode().getWidth() - this.dad.width) / 2, (this.fsDevice.getDisplayMode().getHeight() - this.dad.height) / 2);
            return false;
        }
        try {
            this.fsDevice.setDisplayMode(theMode);
            ((Component)this.fsFrame).setSize(this.fsResolutionX, this.fsResolutionY);
        }
        catch (Exception e) {
            System.err.println("FullScreen API: Failed to go to fullScreen mode");
            e.printStackTrace();
            return false;
        }
        this.dad.setLocation((this.fsDevice.getDisplayMode().getWidth() - this.dad.width) / 2, (this.fsDevice.getDisplayMode().getHeight() - this.dad.height) / 2);
        return true;
    }

    public void keyEvent(KeyEvent e) {
        if (e.equals(lastEvent)) {
            return;
        }
        lastEvent = e;
        if (e.getKeyCode() == 27) {
            if (this.isFullScreen() && e.getID() == 402) {
                this.setFullScreen(false);
            }
        } else if (e.getID() == 401 && (e.getKeyCode() == 70 && e.getModifiers() == fsControlKey || PApplet.platform == 1 && e.getKeyCode() == 10 && e.getModifiers() == 18)) {
            this.setFullScreen(!this.isFullScreen());
        }
    }

    class FSKeyListener
    extends KeyAdapter {
        FullScreen fs;

        public FSKeyListener(FullScreen fs) {
            this.fs = fs;
        }

        public void keyPressed(KeyEvent e) {
            this.fs.keyEvent(e);
        }
    }

    class FSWaitForInitThread
    extends Thread {
        FSWaitForInitThread() {
        }

        public void run() {
            while (FullScreen.this.dad.frameCount < 5) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    System.err.println("FullScreen API: Failed to go to fullscreen mode");
                    return;
                }
            }
            if (!FullScreen.this.setFullScreen(true)) {
                System.err.println("FullScreen API: Failed to go to fullscreen mode");
            }
        }
    }

    class FSWindowListener
    extends WindowAdapter {
        FSWindowListener() {
        }

        public void windowClosing(WindowEvent e) {
            FullScreen.this.dad.exit();
        }
    }
}

