/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.view102;

import com.softsynth.jsyn.view102.CustomFaderListener;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Vector;

public class InternalCustomFader
extends Canvas {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    Vector listeners = new Vector();
    boolean isHorizontal;
    int minVal;
    int maxVal;
    int value;
    int lineIncrement = 1;
    int blockIncrement = 10;
    int visibleAmount;
    int imageSizeX = -1;
    int imageSizeY = -1;
    protected static boolean isShiftDown;
    protected static boolean isMouseDown;
    final int ARROW_SIZE_Z = 20;
    int thumbSize;
    int scrollerLowZ;
    int scrollerMidZ;
    int scrollerHighZ;
    int sizeW;
    int sizeZ;
    int lowZ;
    int highZ;
    static boolean currentlyDragging;
    static InternalCustomFader dragSourceFader;
    static InternalCustomFader dragTargetFader;
    static int dragOffsetX;
    static int dragOffsetY;
    Image offscreenImage;

    public InternalCustomFader(int n, int n2, int n3, int n4, int n5) {
        this.isHorizontal = n == 0;
        this.value = n2;
        this.minVal = n4;
        this.maxVal = n5;
        this.setVisibleAmount(n3);
        this.setBackground(Color.lightGray);
    }

    public void addCustomFaderListener(CustomFaderListener customFaderListener) {
        this.listeners.addElement(customFaderListener);
    }

    public void removeCustomFaderListener(CustomFaderListener customFaderListener) {
        this.listeners.removeElement(customFaderListener);
    }

    public void setValues(int n, int n2, int n3) {
        this.value = n;
        this.minVal = n2;
        this.maxVal = n3;
    }

    public int getValue() {
        return this.value;
    }

    public void setBlockIncrement(int n) {
        this.blockIncrement = n;
    }

    public int getBlockIncrement() {
        return this.blockIncrement;
    }

    public void setUnitIncrement(int n) {
        this.lineIncrement = n;
    }

    public int getLineIncrement() {
        return this.lineIncrement;
    }

    public int getVisibleAmount(int n) {
        return this.visibleAmount;
    }

    public void setVisibleAmount(int n) {
        if (n < 1) {
            n = 1;
        }
        this.visibleAmount = n;
        this.setBlockIncrement(n);
        this.updateThumbSize();
    }

    private void setInternalSize(int n, int n2) {
        if (this.imageSizeX == n && this.imageSizeY == n2) {
            return;
        }
        this.imageSizeX = n;
        this.imageSizeY = n2;
        if (this.isHorizontal) {
            this.sizeZ = n;
            this.sizeW = n2;
        } else {
            this.sizeZ = n2;
            this.sizeW = n;
        }
        if (this.sizeZ < 50) {
            this.sizeZ = 50;
        }
        this.updateThumbSize();
        this.buildOffscreenImage();
    }

    private void updateThumbSize() {
        int n = this.sizeZ - 40;
        this.thumbSize = n * this.visibleAmount / (this.maxVal - this.minVal + this.visibleAmount);
        if (this.thumbSize < 10) {
            this.thumbSize = 10;
        }
        this.lowZ = 20 + this.thumbSize / 2;
        this.highZ = this.sizeZ - this.lowZ;
    }

    private boolean inLowArrow(int n) {
        return n <= 20 && n >= 0;
    }

    private boolean inHighArrow(int n) {
        return n >= this.sizeZ - 20 && n <= this.sizeZ;
    }

    private void tellListeners() {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            CustomFaderListener customFaderListener = (CustomFaderListener)enumeration.nextElement();
            customFaderListener.customFaderValueChanged(this, this.value);
        }
    }

    private int lowOfScroller(int n) {
        return this.scaleClipDeltaZ(this.scrollerMidZ - n);
    }

    private int highOfScroller(int n) {
        return this.scaleClipDeltaZ(n - this.scrollerMidZ);
    }

    private int scaleClipDeltaZ(int n) {
        int n2;
        if (isShiftDown) {
            n2 = this.deltaZToDeltaValue(n);
        } else {
            if (n < this.thumbSize / 2) {
                return 0;
            }
            n2 = this.blockIncrement;
        }
        return n2;
    }

    private void addToValue(int n) {
        this.value += n;
        if (this.value > this.maxVal) {
            this.value = this.maxVal;
        } else if (this.value < this.minVal) {
            this.value = this.minVal;
        }
        this.tellListeners();
        this.repaint();
    }

    private void isOnScroller(int n) {
        currentlyDragging |= n >= this.scrollerLowZ && n <= this.scrollerHighZ;
    }

    protected void handleMousePressed(boolean bl, int n, int n2) {
        isShiftDown = bl;
        isMouseDown = true;
        dragSourceFader = this;
        dragTargetFader = this;
        currentlyDragging = bl;
        this.setFaderByXY(n, n2);
    }

    void setFaderByXY(int n, int n2) {
        int n3;
        if (this.isHorizontal) {
            n3 = n;
            int n4 = n2;
        } else {
            n3 = n2;
            int n5 = n;
        }
        if (this.inLowArrow(n3)) {
            this.addToValue(-this.lineIncrement);
        } else if (this.inHighArrow(n3)) {
            this.addToValue(this.lineIncrement);
        } else {
            int n6 = this.lowOfScroller(n3);
            if (n6 > 0) {
                this.addToValue(-n6);
            } else {
                n6 = this.highOfScroller(n3);
                if (n6 > 0) {
                    this.addToValue(n6);
                } else {
                    this.isOnScroller(n3);
                }
            }
        }
    }

    protected void handleMouseDragged(int n, int n2) {
        if (currentlyDragging) {
            if (dragTargetFader != null && dragTargetFader != dragSourceFader) {
                dragTargetFader.dragFaderByXY(n += dragOffsetX, n2 += dragOffsetY);
            } else {
                this.dragFaderByXY(n, n2);
            }
        }
    }

    void dragFaderByXY(int n, int n2) {
        int n3;
        if (this.isHorizontal) {
            n3 = n;
            int n4 = n2;
        } else {
            n3 = n2;
            int n5 = n;
        }
        this.value = this.zToValue(n3);
        if (this.value > this.maxVal) {
            this.value = this.maxVal;
        } else if (this.value < this.minVal) {
            this.value = this.minVal;
        }
        this.tellListeners();
        this.repaint();
    }

    protected void handleMouseEntered(int n, int n2) {
        if (isMouseDown && isShiftDown) {
            dragTargetFader = this;
            dragOffsetX = InternalCustomFader.dragSourceFader.bounds().x - this.bounds().x;
            dragOffsetY = InternalCustomFader.dragSourceFader.bounds().y - this.bounds().y;
            this.handleMouseDragged(n, n2);
        }
    }

    protected void handleMouseExited(int n, int n2) {
        if (isMouseDown && isShiftDown) {
            dragTargetFader = null;
        }
    }

    protected void handleMouseReleased(int n, int n2) {
        isMouseDown = false;
        currentlyDragging = false;
        dragSourceFader = null;
    }

    private int deltaZToDeltaValue(int n) {
        return n * (this.maxVal - this.minVal) / (this.highZ - this.lowZ);
    }

    private int zToValue(int n) {
        if (n < this.lowZ) {
            return this.minVal;
        }
        if (n > this.highZ) {
            return this.maxVal;
        }
        return this.deltaZToDeltaValue(n - this.lowZ) + this.minVal;
    }

    private int deltaValueToDeltaZ(int n) {
        return n * (this.highZ - this.lowZ) / (this.maxVal - this.minVal);
    }

    private int valueToZ(int n) {
        if (n < this.minVal) {
            return this.lowZ;
        }
        if (n > this.maxVal) {
            return this.highZ;
        }
        return this.deltaValueToDeltaZ(this.value - this.minVal) + this.lowZ;
    }

    public void setValue(int n) {
        if (n < this.minVal || n > this.maxVal) {
            throw new IllegalArgumentException("illegal CustomFader value: " + n);
        }
        this.value = n;
        this.tellListeners();
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void buildOffscreenImage() {
        this.offscreenImage = this.createImage(this.imageSizeX, this.imageSizeY);
    }

    private void zwFillPolygon(Graphics graphics, int[] nArray, int[] nArray2, int n) {
        if (this.isHorizontal) {
            graphics.fillPolygon(nArray, nArray2, nArray.length);
        } else {
            graphics.fillPolygon(nArray2, nArray, nArray.length);
        }
    }

    private void drawLowArrow(Graphics graphics) {
        this.zwDrawBevels(graphics, 1, 1, 20, this.sizeW - 2);
        int n = 6;
        int n2 = 6;
        int n3 = 12;
        int[] nArray = new int[]{n2, n3, n3};
        int[] nArray2 = new int[]{this.sizeW / 2, n, this.sizeW - n};
        graphics.setColor(Color.black);
        this.zwFillPolygon(graphics, nArray, nArray2, nArray.length);
    }

    private void drawHighArrow(Graphics graphics) {
        int n = this.sizeZ - 1 - 20;
        this.zwDrawBevels(graphics, n, 1, this.sizeZ - 1, this.sizeW - 2);
        int n2 = 6;
        int n3 = 6 + n;
        int n4 = 12 + n;
        int[] nArray = new int[]{n3, n3, n4};
        int[] nArray2 = new int[]{n2, this.sizeW - n2, this.sizeW / 2};
        graphics.setColor(Color.black);
        this.zwFillPolygon(graphics, nArray, nArray2, nArray.length);
    }

    private void drawScrollRect(Graphics graphics) {
        this.scrollerMidZ = this.valueToZ(this.value);
        this.scrollerLowZ = this.scrollerMidZ - this.thumbSize / 2;
        this.scrollerHighZ = this.scrollerMidZ + this.thumbSize / 2;
        this.zwDrawBevels(graphics, this.scrollerLowZ, 1, this.scrollerHighZ, this.sizeW - 2);
    }

    private void zwDrawBevels(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 2;
        int[] nArray = new int[]{n, n3, n3 - n5, n + n5};
        int[] nArray2 = new int[]{n2, n2, n2 + n5, n2 + n5};
        graphics.setColor(Color.white);
        this.zwFillPolygon(graphics, nArray, nArray2, nArray.length);
        int[] nArray3 = new int[]{n, n, n + n5, n + n5};
        int[] nArray4 = new int[]{n2, n4, n4 - n5, n2 + n5};
        graphics.setColor(Color.white);
        this.zwFillPolygon(graphics, nArray3, nArray4, nArray3.length);
        int[] nArray5 = new int[]{n3, n3, n3 - n5, n3 - n5};
        int[] nArray6 = new int[]{n2, n4, n4 - n5, n2 + n5};
        graphics.setColor(Color.black);
        this.zwFillPolygon(graphics, nArray5, nArray6, nArray5.length);
        int[] nArray7 = new int[]{n3, n3 - n5, n + n5, n};
        int[] nArray8 = new int[]{n4, n4 - n5, n4 - n5, n4};
        graphics.setColor(Color.black);
        this.zwFillPolygon(graphics, nArray7, nArray8, nArray7.length);
    }

    public void paint(Graphics graphics) {
        this.setInternalSize(this.bounds().width, this.bounds().height);
        if (this.offscreenImage == null) {
            this.buildOffscreenImage();
        }
        if (this.offscreenImage != null) {
            Graphics graphics2 = this.offscreenImage.getGraphics();
            graphics2.setColor(this.getBackground());
            graphics2.fillRect(0, 0, this.imageSizeX, this.imageSizeY);
            graphics2.setColor(Color.black);
            graphics2.drawLine(0, 0, this.imageSizeX - 1, 0);
            graphics2.drawLine(this.imageSizeX - 1, 0, this.imageSizeX - 1, this.imageSizeY - 1);
            graphics2.drawLine(this.imageSizeX - 1, this.imageSizeY - 1, 0, this.imageSizeY - 1);
            graphics2.drawLine(0, 0, 0, this.imageSizeY - 1);
            this.drawLowArrow(graphics2);
            this.drawHighArrow(graphics2);
            this.drawScrollRect(graphics2);
            graphics.drawImage(this.offscreenImage, 0, 0, this);
            graphics2.dispose();
        } else {
            System.out.println("Not ready to draw offscreenImage");
        }
    }

    static {
        currentlyDragging = false;
    }
}

