/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.circuits;

import com.softsynth.jsyn.EnvelopePlayer;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.SynthTable;
import com.softsynth.jsyn.WaveShaper;

public class WaveShapingOscillator
extends SynthNote {
    SineOscillator unitOsc;
    EnvelopePlayer rangeEnv;
    EnvelopePlayer ampEnv;
    SynthEnvelope rangeEnvData;
    SynthEnvelope ampEnvData;
    WaveShaper unitWaveShaper = new WaveShaper();
    SynthInput range;

    public WaveShapingOscillator(SynthTable synthTable) throws SynthException {
        this.add(this.unitWaveShaper);
        this.unitOsc = new SineOscillator();
        this.add(this.unitOsc);
        this.rangeEnv = new EnvelopePlayer();
        this.add(this.rangeEnv);
        this.ampEnv = new EnvelopePlayer();
        this.add(this.ampEnv);
        this.unitWaveShaper.tablePort.setTable(synthTable);
        double[] dArray = new double[]{0.02, 1.0, 0.2, 0.2, 0.2, 0.3, 2.0, 0.01};
        this.rangeEnvData = new SynthEnvelope(dArray);
        this.rangeEnvData.setSustainLoop(2, 4);
        double[] dArray2 = new double[]{0.02, 0.9, 0.1, 0.5, 0.5, 0.0};
        this.ampEnvData = new SynthEnvelope(dArray2);
        this.ampEnvData.setSustainLoop(1, 1);
        this.frequency = this.unitOsc.frequency;
        this.addPort(this.frequency);
        this.amplitude = this.ampEnv.amplitude;
        this.addPort(this.amplitude);
        this.output = this.unitWaveShaper.output;
        this.addPort(this.output);
        this.range = this.unitOsc.amplitude;
        this.addPort(this.range);
        this.rangeEnv.output.connect(this.range);
        this.ampEnv.output.connect(this.unitWaveShaper.amplitude);
        this.unitOsc.output.connect(this.unitWaveShaper.input);
        this.frequency.setup(0.0, 200.0, 800.0);
        this.amplitude.setup(0.0, 0.5, 1.0);
    }

    public void setStage(int n, int n2) throws SynthException {
        switch (n2) {
            case 0: {
                this.rangeEnv.envelopePort.clear(n);
                this.ampEnv.envelopePort.clear(n);
                this.rangeEnv.envelopePort.queueOn(n, this.rangeEnvData);
                this.ampEnv.envelopePort.queueOn(n, this.ampEnvData);
                this.start(n);
                break;
            }
            case 1: {
                this.rangeEnv.envelopePort.queueOff(n, this.rangeEnvData);
                this.ampEnv.envelopePort.queueOff(n, this.ampEnvData, true);
            }
        }
    }
}

