/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.circuits;

import com.softsynth.jsyn.CompareUnit;
import com.softsynth.jsyn.SubtractUnit;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.WhiteNoise;

public class PoissonTrigger
extends SynthCircuit {
    public WhiteNoise whiteNoise = new WhiteNoise();
    public CompareUnit comparator;
    public SubtractUnit subtractor;
    public SynthInput probability;

    public PoissonTrigger() throws SynthException {
        this.add(this.whiteNoise);
        this.subtractor = new SubtractUnit();
        this.add(this.subtractor);
        this.comparator = new CompareUnit();
        this.add(this.comparator);
        this.whiteNoise.output.connect(this.comparator.inputA);
        this.subtractor.output.connect(this.comparator.inputB);
        this.probability = this.subtractor.inputB;
        this.addPort(this.probability, "Probability");
        this.output = this.comparator.output;
        this.addPort(this.output);
        this.whiteNoise.amplitude.set(0.5);
        this.subtractor.inputA.set(0.5);
        this.setFrequency(1.0);
    }

    void setFrequency(double d) {
        double d2 = d / Synth.getFrameRate();
        this.probability.set(d2);
    }
}

