/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.circuits;

import com.softsynth.jsyn.Filter_StateVariable;
import com.softsynth.jsyn.LinearLag;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.SynthVariable;
import com.softsynth.jsyn.WhiteNoise;

public class LagFilteredNoise
extends SynthNote {
    WhiteNoise myNoise = new WhiteNoise();
    Filter_StateVariable myFilter;
    LinearLag ampLag;
    LinearLag freqLag;
    public SynthVariable amplitudeTarget;
    public SynthVariable frequency;
    public SynthVariable amplitudeTime;
    public SynthVariable frequencyTime;
    public SynthVariable resonance;

    public LagFilteredNoise() throws SynthException {
        this.add(this.myNoise);
        this.myFilter = new Filter_StateVariable();
        this.add(this.myFilter);
        this.ampLag = new LinearLag();
        this.add(this.ampLag);
        this.freqLag = new LinearLag();
        this.add(this.freqLag);
        this.freqLag.output.connect(this.myFilter.frequency);
        this.ampLag.output.connect(this.myFilter.amplitude);
        this.myNoise.output.connect(this.myFilter.input);
        this.frequencyTime = this.freqLag.time;
        this.addPort(this.frequencyTime, "frequencyTime");
        this.frequency = this.freqLag.input;
        this.addPort(this.frequency, "targetFrequency");
        this.amplitudeTime = this.ampLag.time;
        this.addPort(this.amplitudeTime, "amplitudeTime");
        this.amplitudeTarget = this.ampLag.input;
        this.addPort(this.amplitudeTarget, "targetAmplitude");
        this.resonance = this.myFilter.resonance;
        this.addPort(this.resonance);
        this.amplitude = this.myNoise.amplitude;
        this.addPort(this.amplitude);
        this.output = this.myFilter.output;
        this.addPort(this.output);
        this.frequency.setup(0.0, 400.0, 3000.0);
        this.amplitude.setup(0.0, 0.3, 1.0);
        this.resonance.setup(1.0E-4, 0.3, 2.0);
        this.amplitudeTarget.setup(0.0, 0.0, 1.0);
        this.amplitudeTime.setup(1.0E-4, 0.1, 2.0);
        this.frequencyTime.setup(1.0E-4, 0.1, 2.0);
    }

    public void setStage(int n, int n2) throws SynthException {
        if (n2 == 0) {
            this.start(n);
        } else {
            this.stop(n);
        }
    }
}

