/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.circuits;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthNote;

public class FMPair
extends SynthNote {
    SineOscillator modOsc;
    SineOscillator carOsc;
    AddUnit adder;
    public SynthInput modFrequency;
    public SynthInput modAmplitude;

    public FMPair() throws SynthException {
        this.makeCircuit();
        this.addAllPorts();
    }

    void makeCircuit() {
        this.modOsc = new SineOscillator();
        this.add(this.modOsc);
        this.carOsc = new SineOscillator();
        this.add(this.carOsc);
        this.adder = new AddUnit();
        this.add(this.adder);
        this.modOsc.output.connect(this.adder.inputB);
        this.adder.output.connect(this.carOsc.frequency);
        this.modFrequency = this.modOsc.frequency;
        this.modAmplitude = this.modOsc.amplitude;
        this.frequency = this.adder.inputA;
        this.amplitude = this.carOsc.amplitude;
        this.output = this.carOsc.output;
        this.modFrequency.setup(0.0, 600.0, 12000.0);
        this.modAmplitude.setup(0.0, 200.0, 10000.0);
        this.frequency.setup(0.0, 300.0, 8000.0);
        this.amplitude.setup(0.0, 0.5, 10.0);
    }

    void addAllPorts() {
        this.addPort(this.modFrequency, "modFrequency");
        this.addPort(this.modAmplitude, "modAmplitude");
        this.addPort(this.frequency, "frequency");
        this.addPort(this.amplitude);
        this.addPort(this.output);
    }
}

