/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthScalarPort;
import com.softsynth.jsyn.SynthSound;

public class SynthVariable
extends SynthScalarPort {
    double min;
    double max;
    double lastValue = 0.0;
    static double[] mins = new double[8];
    static double[] maxs = new double[8];

    SynthVariable(SynthSound synthSound, String string) throws SynthException {
        super(synthSound, string);
        this.setMinMaxByType(this.getSignalType());
    }

    public void setSignalType(int n, int n2) throws SynthException {
        super.setSignalType(n, n2);
    }

    void setMinMaxByType(int n) {
        this.min = mins[n];
        this.max = maxs[n];
    }

    public void setAt(int n, int n2, double d) throws SynthException {
        this.set(n, d, n2);
    }

    public void setAt(int n, double d) throws SynthException {
        this.set(n, d, 0);
    }

    public void set(int n, double d, int n2) throws SynthException {
        int n3;
        if (Synth.verbosity >= 2) {
            System.out.println("SynthVariable.set(" + n + ", " + Integer.toHexString(this.peerToken) + ", " + this.name + ", " + n2 + ", " + d + ")");
        }
        if ((n3 = this.sound.context.setPortAt(n, this.peerToken, this.portHash, n2, d)) < 0) {
            throw new SynthException(n3, this.name, this.peerToken, n2);
        }
        this.lastValue = d;
    }

    public void set(int n, double d) throws SynthException {
        this.set(n, d, 0);
    }

    public void set(double d, int n) throws SynthException {
        int n2;
        if (Synth.verbosity >= 2) {
            System.out.println("SynthVariable.set(" + Integer.toHexString(this.peerToken) + ", " + this.name + ", " + n + ", " + d + ")");
        }
        if ((n2 = this.sound.context.setPort(this.peerToken, this.portHash, n, d)) < 0) {
            throw new SynthException(n2, this.name, this.peerToken, n);
        }
        this.lastValue = d;
    }

    public void set(double d) throws SynthException {
        this.set(d, 0);
    }

    public double get(int n) throws SynthException {
        return this.lastValue;
    }

    public double getCurrent(int n) throws SynthException {
        return super.get(n);
    }

    public double getCurrent() {
        return this.getCurrent(0);
    }

    public void setMin(double d) {
        this.min = d;
    }

    public double getMin() {
        return this.min;
    }

    public void setMax(double d) {
        this.max = d;
    }

    public double getMax() {
        return this.max;
    }

    public void setup(double d, double d2, double d3) throws SynthException {
        this.setMin(d);
        this.setMax(d3);
        this.set(d2);
    }

    static {
        SynthVariable.mins[0] = -1.0;
        SynthVariable.maxs[0] = 1.0;
        SynthVariable.mins[1] = 0.0;
        SynthVariable.maxs[1] = 2.0;
        SynthVariable.mins[2] = 0.0;
        SynthVariable.maxs[2] = 10000.0;
        SynthVariable.mins[3] = 0.0;
        SynthVariable.maxs[3] = 88200.0;
        SynthVariable.mins[4] = 0.001;
        SynthVariable.maxs[4] = 10.0;
        SynthVariable.mins[5] = 0.0;
        SynthVariable.maxs[5] = 20.0;
        SynthVariable.mins[6] = 0.0;
        SynthVariable.maxs[6] = 10000.0;
        SynthVariable.mins[7] = -100000.0;
        SynthVariable.maxs[7] = 100000.0;
    }
}

