/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthObject;

public class SynthTable
extends SynthObject {
    int numFrames;

    public SynthTable(SynthContext synthContext) {
        super(synthContext);
    }

    public SynthTable() {
        this(Synth.getSharedContext());
    }

    public SynthTable(SynthContext synthContext, int n) throws SynthException {
        super(synthContext);
        this.allocate(n);
    }

    public SynthTable(int n) throws SynthException {
        this(Synth.getSharedContext(), n);
    }

    public SynthTable(SynthContext synthContext, double[] dArray) throws SynthException {
        this(synthContext, dArray.length);
        this.write(dArray);
    }

    public SynthTable(double[] dArray) throws SynthException {
        this(dArray.length);
        this.write(dArray);
    }

    public void allocate(int n) throws SynthException {
        this.delete();
        this.numFrames = n;
        this.peerToken = this.context.createTable(n);
        if (this.peerToken < 0) {
            throw new SynthException(this.peerToken, n);
        }
    }

    public void write(int n, int n2, short[] sArray, int n3, int n4) throws SynthException {
        int n5 = this.context.writeTable(this.peerToken, n, n4, sArray, n3, sArray.length);
        if (n5 < 0) {
            throw new SynthException(n5, this.peerToken, n);
        }
    }

    public void write(int n, short[] sArray, int n2, int n3) throws SynthException {
        this.write(n, 0, sArray, n2, n3);
    }

    public void write(short[] sArray) throws SynthException {
        this.write(0, 0, sArray, 0, sArray.length);
    }

    public void write(int n, int n2, double[] dArray, int n3, int n4) throws SynthException {
        int n5 = this.context.writeTableDoubles(this.peerToken, n, n4, dArray, n3, dArray.length);
        if (n5 < 0) {
            throw new SynthException(n5, this.peerToken, n);
        }
    }

    public void write(int n, double[] dArray, int n2, int n3) throws SynthException {
        this.write(n, 0, dArray, n2, n3);
    }

    public void write(double[] dArray) throws SynthException {
        this.write(0, 0, dArray, 0, dArray.length);
    }

    public int length() {
        return this.numFrames;
    }
}

