/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import java.util.Observable;

public class SynthObject
extends Observable {
    int peerToken = 0;
    int nativeError = 0;
    SynthContext context;

    public SynthObject(SynthContext synthContext) {
        this.setSynthContext(synthContext);
        if (synthContext.isTrackingEnabled()) {
            this.track();
        }
    }

    public SynthContext getSynthContext() {
        return this.context;
    }

    public void setSynthContext(SynthContext synthContext) {
        this.context = synthContext;
    }

    public static boolean isTrackingEnabled() {
        return Synth.getSharedContext().isTrackingEnabled();
    }

    public static void enableTracking(boolean bl) {
        Synth.getSharedContext().enableTracking(bl);
    }

    public synchronized void track() {
        this.context.track(this);
    }

    public int getPeer() throws SynthException {
        return this.peerToken;
    }

    public static void deleteAll() throws SynthException {
        Synth.getSharedContext().deleteAll();
    }

    public synchronized void delete() throws SynthException {
        this.context.unTrack(this);
        if (this.peerToken != 0) {
            if (Synth.verbosity >= 1) {
                System.out.println("Synth object deleted = " + this);
            }
            int n = this.context.delete(this);
            int n2 = this.peerToken;
            this.peerToken = 0;
            if (n < 0) {
                throw new SynthException(n, n2);
            }
        }
    }

    public static void enableDeletionByGarbageCollector(boolean bl) {
        Synth.getSharedContext().enableDeletionByGarbageCollector(bl);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.context.deleteByGarbageCollector) {
            try {
                this.delete();
            }
            catch (SynthException synthException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return super.toString() + ", peer = 0x" + Integer.toHexString(this.peerToken);
    }
}

