/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;

public class SynthNote
extends SynthCircuit {
    public SynthInput frequency;
    public SynthInput amplitude;

    public SynthNote() throws SynthException {
        super(Synth.getSharedContext());
    }

    public SynthNote(SynthContext synthContext) throws SynthException {
        super(synthContext);
    }

    public void noteOn(int n, double d, double d2) {
        if (this.frequency != null) {
            this.frequency.set(n, d);
        }
        if (this.amplitude != null) {
            this.amplitude.set(n, d2);
        }
        this.setStage(n, 0);
    }

    public void noteOff(int n) {
        this.setStage(n, 1);
    }

    public void noteOnFor(int n, int n2, double d, double d2) {
        this.noteOn(n, d, d2);
        this.noteOff(n + n2);
    }

    public void note(int n, int n2, double d, double d2) {
        this.noteOn(n, d, d2);
        this.noteOff(n + n2 / 2);
    }
}

