/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.CuePoint;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthObject;
import java.util.Vector;

public class SynthChannelData
extends SynthObject {
    int maxFrames;
    int numFrames;
    int sustainBegin = -1;
    int sustainEnd = -1;
    int releaseBegin = -1;
    int releaseEnd = -1;
    public Vector cuePoints;

    public SynthChannelData() {
        this(0);
    }

    public SynthChannelData(int n) {
        this(Synth.getSharedContext(), n);
    }

    public SynthChannelData(SynthContext synthContext, int n) {
        super(synthContext);
        this.maxFrames = n;
        this.numFrames = n;
    }

    public int getNumFrames() {
        return this.numFrames;
    }

    public int getMaxFrames() {
        return this.maxFrames;
    }

    public void setNumFrames(int n) {
        if (n > this.maxFrames) {
            n = this.maxFrames;
        }
        this.numFrames = n;
    }

    public void setSustainLoop(int n, int n2) {
        this.sustainBegin = n;
        this.sustainEnd = n2;
    }

    public int getSustainBegin() {
        return this.sustainBegin;
    }

    public int getSustainEnd() {
        return this.sustainEnd;
    }

    public int getSustainSize() {
        return this.sustainEnd - this.sustainBegin;
    }

    public void setReleaseLoop(int n, int n2) {
        this.releaseBegin = n;
        this.releaseEnd = n2;
    }

    public int getReleaseBegin() {
        return this.releaseBegin;
    }

    public int getReleaseEnd() {
        return this.releaseEnd;
    }

    public int getReleaseSize() {
        return this.releaseEnd - this.releaseBegin;
    }

    public void insertSortedCue(CuePoint cuePoint) {
        if (this.cuePoints == null) {
            this.cuePoints = new Vector();
        }
        int n = this.cuePoints.size();
        int n2 = 0;
        while (n2 < this.cuePoints.size()) {
            CuePoint cuePoint2 = (CuePoint)this.cuePoints.elementAt(n2);
            if (cuePoint2.getPosition() > cuePoint.getPosition()) {
                n = n2;
                break;
            }
            ++n2;
        }
        this.cuePoints.insertElementAt(cuePoint, n);
    }

    public CuePoint findCuePoint(int n) {
        if (this.cuePoints == null) {
            return null;
        }
        int n2 = this.cuePoints.size();
        int n3 = 0;
        while (n3 < n2) {
            CuePoint cuePoint = (CuePoint)this.cuePoints.elementAt(n3);
            if (cuePoint.getID() == n) {
                return cuePoint;
            }
            ++n3;
        }
        return null;
    }

    public int findCuePosition(int n) {
        CuePoint cuePoint = this.findCuePoint(n);
        if (cuePoint == null) {
            return -1;
        }
        return cuePoint.getPosition();
    }
}

