/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;

public class PGraphicsJava2D
extends PGraphics {
    public Graphics2D g2;
    GeneralPath gpath;
    int transformCount;
    AffineTransform[] transformStack = new AffineTransform[32];
    double[] transform = new double[6];
    Line2D.Float line = new Line2D.Float();
    Ellipse2D.Float ellipse = new Ellipse2D.Float();
    Rectangle2D.Float rect = new Rectangle2D.Float();
    Arc2D.Float arc = new Arc2D.Float();
    protected Color tintColorObject;
    protected Color fillColorObject;
    public boolean fillGradient;
    public Paint fillGradientObject;
    protected Color strokeColorObject;
    public boolean strokeGradient;
    public Paint strokeGradientObject;
    float[] curveX = new float[4];
    float[] curveY = new float[4];
    boolean breakShape;
    int[] clearPixels;
    static int[] getset = new int[1];

    public PGraphicsJava2D(int n, int n2, PApplet pApplet) {
        super(n, n2, pApplet);
    }

    public void resize(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.width1 = this.width - 1;
        this.height1 = this.height - 1;
        this.allocate();
        this.reapplySettings();
    }

    protected void allocate() {
        this.image = new BufferedImage(this.width, this.height, 2);
        this.g2 = (Graphics2D)this.image.getGraphics();
    }

    public void beginDraw() {
        this.checkSettings();
        this.resetMatrix();
        this.vertexCount = 0;
    }

    public void endDraw() {
        if (!this.mainDrawingSurface) {
            this.loadPixels();
        }
        this.modified = true;
    }

    public void beginShape(int n) {
        this.shape = n;
        this.vertexCount = 0;
        this.splineVertexCount = 0;
        this.gpath = null;
    }

    public void textureMode(int n) {
        this.unavailableError("textureMode(mode)");
    }

    public void texture(PImage pImage) {
        this.unavailableError("texture(image)");
    }

    public void vertex(float f, float f2) {
        this.splineVertexCount = 0;
        if (this.vertexCount == this.vertices.length) {
            float[][] fArray = new float[this.vertexCount << 1][36];
            System.arraycopy(this.vertices, 0, fArray, 0, this.vertexCount);
            this.vertices = fArray;
        }
        this.vertices[this.vertexCount][9] = f;
        this.vertices[this.vertexCount][10] = f2;
        ++this.vertexCount;
        switch (this.shape) {
            case 16: {
                this.point(f, f2);
                break;
            }
            case 32: {
                if (this.vertexCount % 2 != 0) break;
                this.line(this.vertices[this.vertexCount - 2][9], this.vertices[this.vertexCount - 2][10], f, f2);
                break;
            }
            case 64: {
                if (this.vertexCount % 3 != 0) break;
                this.triangle(this.vertices[this.vertexCount - 3][9], this.vertices[this.vertexCount - 3][10], this.vertices[this.vertexCount - 2][9], this.vertices[this.vertexCount - 2][10], f, f2);
                break;
            }
            case 65: {
                if (this.vertexCount < 3) break;
                this.triangle(this.vertices[this.vertexCount - 2][9], this.vertices[this.vertexCount - 2][10], this.vertices[this.vertexCount - 1][9], this.vertices[this.vertexCount - 1][10], this.vertices[this.vertexCount - 3][9], this.vertices[this.vertexCount - 3][10]);
                break;
            }
            case 66: {
                if (this.vertexCount == 3) {
                    this.triangle(this.vertices[0][9], this.vertices[0][10], this.vertices[1][9], this.vertices[1][10], f, f2);
                    break;
                }
                if (this.vertexCount <= 3) break;
                this.gpath = new GeneralPath();
                this.gpath.moveTo(this.vertices[0][9], this.vertices[0][10]);
                this.gpath.lineTo(this.vertices[this.vertexCount - 2][9], this.vertices[this.vertexCount - 2][10]);
                this.gpath.lineTo(f, f2);
                this.draw_shape(this.gpath);
                break;
            }
            case 128: {
                if (this.vertexCount % 4 != 0) break;
                this.quad(this.vertices[this.vertexCount - 4][9], this.vertices[this.vertexCount - 4][10], this.vertices[this.vertexCount - 3][9], this.vertices[this.vertexCount - 3][10], this.vertices[this.vertexCount - 2][9], this.vertices[this.vertexCount - 2][10], f, f2);
                break;
            }
            case 129: {
                if (this.vertexCount < 4 || this.vertexCount % 2 != 0) break;
                this.quad(this.vertices[this.vertexCount - 4][9], this.vertices[this.vertexCount - 4][10], this.vertices[this.vertexCount - 2][9], this.vertices[this.vertexCount - 2][10], f, f2, this.vertices[this.vertexCount - 3][9], this.vertices[this.vertexCount - 3][10]);
                break;
            }
            case 256: {
                if (this.gpath == null) {
                    this.gpath = new GeneralPath();
                    this.gpath.moveTo(f, f2);
                    break;
                }
                if (this.breakShape) {
                    this.gpath.moveTo(f, f2);
                    this.breakShape = false;
                    break;
                }
                this.gpath.lineTo(f, f2);
            }
        }
    }

    public void vertex(float f, float f2, float f3, float f4) {
        this.unavailableError("vertex(x, y, u, v");
    }

    public void vertex(float f, float f2, float f3) {
        this.depthErrorXYZ("vertex");
    }

    public void vertex(float f, float f2, float f3, float f4, float f5) {
        this.depthErrorXYZ("vertex");
    }

    public void bezierVertex(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.gpath == null) {
            throw new RuntimeException("Must call vertex() at least once before using bezierVertex()");
        }
        switch (this.shape) {
            case 256: {
                this.gpath.curveTo(f, f2, f3, f4, f5, f6);
                break;
            }
            default: {
                throw new RuntimeException("bezierVertex() can only be used with LINE_STRIP, LINE_LOOP, or POLYGON");
            }
        }
    }

    public void curveVertex(float f, float f2) {
        if (this.shape != 256) {
            throw new RuntimeException("curveVertex() can only be used with POLYGON shapes");
        }
        if (!this.curve_inited) {
            this.curve_init();
        }
        this.vertexCount = 0;
        if (this.splineVertices == null) {
            this.splineVertices = new float[128][36];
        }
        if (this.splineVertexCount == 128) {
            System.arraycopy(this.splineVertices[125], 0, this.splineVertices[0], 0, 36);
            System.arraycopy(this.splineVertices[126], 0, this.splineVertices[1], 0, 36);
            System.arraycopy(this.splineVertices[127], 0, this.splineVertices[2], 0, 36);
            this.splineVertexCount = 3;
        }
        if (this.splineVertexCount >= 3) {
            this.curveX[0] = this.splineVertices[this.splineVertexCount - 3][9];
            this.curveY[0] = this.splineVertices[this.splineVertexCount - 3][10];
            this.curveX[1] = this.splineVertices[this.splineVertexCount - 2][9];
            this.curveY[1] = this.splineVertices[this.splineVertexCount - 2][10];
            this.curveX[2] = this.splineVertices[this.splineVertexCount - 1][9];
            this.curveY[2] = this.splineVertices[this.splineVertexCount - 1][10];
            this.curveX[3] = f;
            this.curveY[3] = f2;
            this.curveToBezierMatrix.mult(this.curveX, this.curveX);
            this.curveToBezierMatrix.mult(this.curveY, this.curveY);
            if (this.gpath == null) {
                this.gpath = new GeneralPath();
                this.gpath.moveTo(this.curveX[0], this.curveY[0]);
            }
            this.gpath.curveTo(this.curveX[1], this.curveY[1], this.curveX[2], this.curveY[2], this.curveX[3], this.curveY[3]);
        }
        this.splineVertices[this.splineVertexCount][9] = f;
        this.splineVertices[this.splineVertexCount][10] = f2;
        ++this.splineVertexCount;
    }

    public void breakShape() {
        this.breakShape = true;
    }

    public void endShape(int n) {
        if (this.gpath != null && this.shape == 256) {
            if (n == 2) {
                this.gpath.closePath();
            }
            this.draw_shape(this.gpath);
        }
        this.shape = 0;
    }

    protected void fill_shape(Shape shape) {
        if (this.fillGradient) {
            this.g2.setPaint(this.fillGradientObject);
            this.g2.fill(shape);
        } else if (this.fill) {
            this.g2.setColor(this.fillColorObject);
            this.g2.fill(shape);
        }
    }

    protected void stroke_shape(Shape shape) {
        if (this.strokeGradient) {
            this.g2.setPaint(this.strokeGradientObject);
            this.g2.draw(shape);
        } else if (this.stroke) {
            this.g2.setColor(this.strokeColorObject);
            this.g2.draw(shape);
        }
    }

    protected void draw_shape(Shape shape) {
        if (this.fillGradient) {
            this.g2.setPaint(this.fillGradientObject);
            this.g2.fill(shape);
        } else if (this.fill) {
            this.g2.setColor(this.fillColorObject);
            this.g2.fill(shape);
        }
        if (this.strokeGradient) {
            this.g2.setPaint(this.strokeGradientObject);
            this.g2.draw(shape);
        } else if (this.stroke) {
            this.g2.setColor(this.strokeColorObject);
            this.g2.draw(shape);
        }
    }

    public void point(float f, float f2) {
        this.line(f, f2, f, f2);
    }

    public void line(float f, float f2, float f3, float f4) {
        this.line.setLine(f, f2, f3, f4);
        this.stroke_shape(this.line);
    }

    public void triangle(float f, float f2, float f3, float f4, float f5, float f6) {
        this.gpath = new GeneralPath();
        this.gpath.moveTo(f, f2);
        this.gpath.lineTo(f3, f4);
        this.gpath.lineTo(f5, f6);
        this.gpath.closePath();
        this.draw_shape(this.gpath);
    }

    public void quad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f2);
        generalPath.lineTo(f3, f4);
        generalPath.lineTo(f5, f6);
        generalPath.lineTo(f7, f8);
        generalPath.closePath();
        this.draw_shape(generalPath);
    }

    protected void rectImpl(float f, float f2, float f3, float f4) {
        this.rect.setFrame(f, f2, f3 - f, f4 - f2);
        this.draw_shape(this.rect);
    }

    protected void ellipseImpl(float f, float f2, float f3, float f4) {
        this.ellipse.setFrame(f, f2, f3, f4);
        this.draw_shape(this.ellipse);
    }

    protected void arcImpl(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7;
        if (f6 - f5 >= (float)Math.PI * 2) {
            f5 = 0.0f;
            f6 = 360.0f;
        } else {
            f5 = -f5 * 57.295776f;
            f6 = -f6 * 57.295776f;
            while (f5 < 0.0f) {
                f5 += 360.0f;
                f6 += 360.0f;
            }
            if (f5 > f6) {
                f7 = f5;
                f5 = f6;
                f6 = f7;
            }
        }
        f7 = f6 - f5;
        if (this.fill) {
            this.arc.setArc(f, f2, f3, f4, f5, f7, 2);
            this.fill_shape(this.arc);
        }
        if (this.stroke) {
            this.arc.setArc(f, f2, f3, f4, f5, f7, 0);
            this.stroke_shape(this.arc);
        }
    }

    public void bezierDetail(int n) {
    }

    public void curveDetail(int n) {
    }

    protected void imageImpl(PImage pImage, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4) {
        if (pImage.cache == null || !(pImage.cache instanceof ImageCache)) {
            // empty if block
        }
        if (pImage.cache == null) {
            pImage.cache = new ImageCache(pImage);
            pImage.updatePixels();
            pImage.modified = true;
        }
        ImageCache imageCache = (ImageCache)pImage.cache;
        if (this.tint && !imageCache.tinted || this.tint && imageCache.tintedColor != this.tintColor || !this.tint && imageCache.tinted) {
            pImage.updatePixels();
        }
        if (pImage.modified) {
            imageCache.update(this.tint, this.tintColor);
            pImage.modified = false;
        }
        this.g2.drawImage(((ImageCache)pImage.cache).image, (int)f, (int)f2, (int)f3, (int)f4, n, n2, n3, n4, null);
    }

    public float textAscent() {
        if (this.textFontNative == null) {
            return super.textAscent();
        }
        return this.textFontNativeMetrics.getAscent();
    }

    public float textDescent() {
        if (this.textFontNative == null) {
            return super.textDescent();
        }
        return this.textFontNativeMetrics.getDescent();
    }

    public void textSize(float f) {
        if (this.textFontNative != null) {
            this.textFontNative = this.textFontNative.deriveFont(f);
            this.g2.setFont(this.textFontNative);
            this.textFontNativeMetrics = this.g2.getFontMetrics(this.textFontNative);
        }
        super.textSize(f);
    }

    protected float textWidthImpl(char[] cArray, int n, int n2) {
        if (this.textFontNative == null) {
            return super.textWidthImpl(cArray, n, n2);
        }
        int n3 = n2 - n;
        return this.textFontNativeMetrics.charsWidth(cArray, n, n3);
    }

    protected void textLinePlacedImpl(char[] cArray, int n, int n2, float f, float f2) {
        if (this.textFontNative == null) {
            super.textLinePlacedImpl(cArray, n, n2, f, f2);
            return;
        }
        Object object = this.g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (object == null) {
            object = RenderingHints.VALUE_ANTIALIAS_DEFAULT;
        }
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.textFont.smooth ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        this.g2.setColor(this.fillColorObject);
        int n3 = n2 - n;
        this.g2.drawChars(cArray, n, n3, (int)(f + 0.5f), (int)(f2 + 0.5f));
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        this.textX = f + this.textWidthImpl(cArray, n, n2);
        this.textY = f2;
        this.textZ = 0.0f;
    }

    public void translate(float f, float f2) {
        this.g2.translate(f, f2);
    }

    public void rotate(float f) {
        this.g2.rotate(f);
    }

    public void scale(float f) {
        this.g2.scale(f, f);
    }

    public void scale(float f, float f2) {
        this.g2.scale(f, f2);
    }

    public void pushMatrix() {
        if (this.transformCount == this.transformStack.length) {
            throw new RuntimeException("pushMatrix() cannot use push more than " + this.transformStack.length + " times");
        }
        this.transformStack[this.transformCount] = this.g2.getTransform();
        ++this.transformCount;
    }

    public void popMatrix() {
        if (this.transformCount == 0) {
            throw new RuntimeException("missing a popMatrix() to go with that pushMatrix()");
        }
        --this.transformCount;
        this.g2.setTransform(this.transformStack[this.transformCount]);
    }

    public void resetMatrix() {
        this.g2.setTransform(new AffineTransform());
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6) {
        this.g2.transform(new AffineTransform(f, f4, f2, f5, f3, f6));
    }

    public void loadMatrix() {
        this.g2.getTransform().getMatrix(this.transform);
        this.m00 = (float)this.transform[0];
        this.m01 = (float)this.transform[2];
        this.m02 = (float)this.transform[4];
        this.m10 = (float)this.transform[1];
        this.m11 = (float)this.transform[3];
        this.m12 = (float)this.transform[5];
    }

    public float screenX(float f, float f2) {
        this.loadMatrix();
        return super.screenX(f, f2);
    }

    public float screenY(float f, float f2) {
        this.loadMatrix();
        return super.screenY(f, f2);
    }

    protected void tintFromCalc() {
        super.tintFromCalc();
        this.tintColorObject = new Color(this.tintColor, true);
    }

    protected void fillFromCalc() {
        super.fillFromCalc();
        this.fillColorObject = new Color(this.fillColor, true);
        this.fillGradient = false;
    }

    protected void strokeFromCalc() {
        super.strokeFromCalc();
        this.strokeColorObject = new Color(this.strokeColor, true);
        this.strokeGradient = false;
    }

    public void strokeWeight(float f) {
        super.strokeWeight(f);
        this.set_stroke();
    }

    public void strokeJoin(int n) {
        super.strokeJoin(n);
        this.set_stroke();
    }

    public void strokeCap(int n) {
        super.strokeCap(n);
        this.set_stroke();
    }

    protected void set_stroke() {
        int n = 0;
        if (this.strokeCap == 2) {
            n = 1;
        } else if (this.strokeCap == 4) {
            n = 2;
        }
        int n2 = 2;
        if (this.strokeJoin == 8) {
            n2 = 0;
        } else if (this.strokeJoin == 2) {
            n2 = 1;
        }
        this.g2.setStroke(new BasicStroke(this.strokeWeight, n, n2));
    }

    public void background(PImage pImage) {
        if (pImage.width != this.width || pImage.height != this.height) {
            throw new RuntimeException("background image must be the same size as your application");
        }
        if (pImage.format != 1 && pImage.format != 2) {
            throw new RuntimeException("background images should be RGB or ARGB");
        }
        this.set(0, 0, pImage);
    }

    public void clear() {
        if (this.backgroundAlpha) {
            WritableRaster writableRaster = ((BufferedImage)this.image).getRaster();
            if (this.clearPixels == null || this.clearPixels.length < this.width) {
                this.clearPixels = new int[this.width];
            }
            Arrays.fill(this.clearPixels, this.backgroundColor);
            for (int i = 0; i < this.height; ++i) {
                writableRaster.setDataElements(0, i, this.width, 1, this.clearPixels);
            }
        } else {
            this.pushMatrix();
            this.resetMatrix();
            this.g2.setColor(new Color(this.backgroundColor));
            this.g2.fillRect(0, 0, this.width, this.height);
            this.popMatrix();
        }
    }

    public void smooth() {
        this.smooth = true;
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
    }

    public void noSmooth() {
        this.smooth = false;
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
    }

    public void beginRaw(PGraphics pGraphics) {
        throw new RuntimeException("beginRaw() not available with this renderer");
    }

    public void endRaw() {
    }

    public void loadPixels() {
        if (this.pixels == null || this.pixels.length != this.width * this.height) {
            this.pixels = new int[this.width * this.height];
        }
        WritableRaster writableRaster = ((BufferedImage)this.image).getRaster();
        writableRaster.getDataElements(0, 0, this.width, this.height, this.pixels);
    }

    public void updatePixels() {
        WritableRaster writableRaster = ((BufferedImage)this.image).getRaster();
        writableRaster.setDataElements(0, 0, this.width, this.height, this.pixels);
    }

    public void updatePixels(int n, int n2, int n3, int n4) {
        if (n != 0 || n2 != 0 || n3 != this.width || n4 != this.height) {
            throw new RuntimeException("updatePixels(x, y, c, d) not implemented");
        }
        this.updatePixels();
    }

    public int get(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return 0;
        }
        WritableRaster writableRaster = ((BufferedImage)this.image).getRaster();
        writableRaster.getDataElements(n, n2, getset);
        return getset[0];
    }

    public PImage get(int n, int n2, int n3, int n4) {
        if (this.imageMode == 1) {
            n3 -= n;
            n4 -= n2;
        } else if (this.imageMode == 3) {
            n -= n3 / 2;
            n2 -= n4 / 2;
        }
        if (n < 0) {
            n3 += n;
            n = 0;
        }
        if (n2 < 0) {
            n4 += n2;
            n2 = 0;
        }
        if (n + n3 > this.width) {
            n3 = this.width - n;
        }
        if (n2 + n4 > this.height) {
            n4 = this.height - n2;
        }
        PImage pImage = new PImage(n3, n4);
        pImage.parent = this.parent;
        WritableRaster writableRaster = ((BufferedImage)this.image).getRaster();
        writableRaster.getDataElements(n, n2, n3, n4, pImage.pixels);
        return pImage;
    }

    public PImage get() {
        return this.get(0, 0, this.width, this.height);
    }

    public void set(int n, int n2, int n3) {
        if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            return;
        }
        PGraphicsJava2D.getset[0] = n3;
        WritableRaster writableRaster = ((BufferedImage)this.image).getRaster();
        writableRaster.setDataElements(n, n2, getset);
    }

    protected void setImpl(int n, int n2, int n3, int n4, int n5, int n6, PImage pImage) {
        if (this.imageMode == 3) {
            n -= pImage.width / 2;
            n2 -= pImage.height / 2;
        }
        WritableRaster writableRaster = ((BufferedImage)this.image).getRaster();
        if (n3 == 0 && n4 == 0 && n5 == pImage.width && n6 == pImage.height) {
            writableRaster.setDataElements(n, n2, pImage.width, pImage.height, pImage.pixels);
        } else {
            int n7 = pImage.imageMode;
            pImage.imageMode = 0;
            PImage pImage2 = pImage.get(n3, n4, n5, n6);
            pImage.imageMode = n7;
            writableRaster.setDataElements(n, n2, pImage2.width, pImage2.height, pImage2.pixels);
        }
    }

    public void mask(int[] nArray) {
        throw new RuntimeException("mask() cannot be used with JAVA2D");
    }

    public void mask(PImage pImage) {
        throw new RuntimeException("mask() cannot be used with JAVA2D");
    }

    public void filter(int n) {
        this.loadPixels();
        super.filter(n);
        this.updatePixels();
    }

    public void filter(int n, float f) {
        this.loadPixels();
        super.filter(n, f);
        this.updatePixels();
    }

    public void copy(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (n3 != n7 || n4 != n8) {
            this.copy(this, n, n2, n3, n4, n5, n6, n7, n8);
        } else {
            if (this.imageMode == 1) {
                n3 -= n;
                n4 -= n2;
            } else if (this.imageMode == 3) {
                n -= n3 / 2;
                n2 -= n4 / 2;
            }
            this.g2.copyArea(n, n2, n3, n4, n5 -= n, n6 -= n2);
        }
    }

    public void copy(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.loadPixels();
        super.copy(pImage, n, n2, n3, n4, n5, n6, n7, n8);
        this.updatePixels();
    }

    public void blend(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.loadPixels();
        super.blend(n, n2, n3, n4, n5, n6, n7, n8, n9);
        this.updatePixels();
    }

    public void blend(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.loadPixels();
        super.blend(pImage, n, n2, n3, n4, n5, n6, n7, n8, n9);
        this.updatePixels();
    }

    public void save(String string) {
        this.loadPixels();
        super.save(string);
    }

    class ImageCache {
        PImage source;
        boolean tinted;
        int tintedColor;
        int[] tintedPixels;
        BufferedImage image;

        public ImageCache(PImage pImage) {
            this.source = pImage;
        }

        public void update(boolean bl, int n) {
            boolean bl2;
            boolean bl3;
            int n2 = 2;
            boolean bl4 = bl3 = (n & 0xFF000000) == -16777216;
            if (this.source.format == 1 && (!bl || bl && bl3)) {
                n2 = 1;
            }
            boolean bl5 = bl2 = this.image != null && this.image.getType() != n2;
            if (this.image == null || bl2) {
                this.image = new BufferedImage(this.source.width, this.source.height, n2);
            }
            WritableRaster writableRaster = this.image.getRaster();
            if (bl) {
                if (this.tintedPixels == null || this.tintedPixels.length != this.source.width) {
                    this.tintedPixels = new int[this.source.width];
                }
                int n3 = n >> 24 & 0xFF;
                int n4 = n >> 16 & 0xFF;
                int n5 = n >> 8 & 0xFF;
                int n6 = n & 0xFF;
                if (n2 == 1) {
                    int n7 = 0;
                    for (int i = 0; i < this.source.height; ++i) {
                        for (int j = 0; j < this.source.width; ++j) {
                            int n8 = this.source.pixels[n7++];
                            int n9 = n8 >> 16 & 0xFF;
                            int n10 = n8 >> 8 & 0xFF;
                            int n11 = n8 & 0xFF;
                            this.tintedPixels[j] = (n4 * n9 & 0xFF00) << 8 | n5 * n10 & 0xFF00 | (n6 * n11 & 0xFF00) >> 8;
                        }
                        writableRaster.setDataElements(0, i, this.source.width, 1, this.tintedPixels);
                    }
                } else if (n2 == 2) {
                    int n12 = 0;
                    for (int i = 0; i < this.source.height; ++i) {
                        int n13;
                        int n14;
                        int n15;
                        int n16;
                        int n17;
                        int n18;
                        if (this.source.format == 1) {
                            n18 = n & 0xFF000000;
                            for (n17 = 0; n17 < this.source.width; ++n17) {
                                n16 = this.source.pixels[n12++];
                                n15 = n16 >> 16 & 0xFF;
                                n14 = n16 >> 8 & 0xFF;
                                n13 = n16 & 0xFF;
                                this.tintedPixels[n17] = n18 | (n4 * n15 & 0xFF00) << 8 | n5 * n14 & 0xFF00 | (n6 * n13 & 0xFF00) >> 8;
                            }
                        } else if (this.source.format == 2) {
                            for (n18 = 0; n18 < this.source.width; ++n18) {
                                n17 = this.source.pixels[n12++];
                                n16 = n17 >> 24 & 0xFF;
                                n15 = n17 >> 16 & 0xFF;
                                n14 = n17 >> 8 & 0xFF;
                                n13 = n17 & 0xFF;
                                this.tintedPixels[n18] = (n3 * n16 & 0xFF00) << 16 | (n4 * n15 & 0xFF00) << 8 | n5 * n14 & 0xFF00 | (n6 * n13 & 0xFF00) >> 8;
                            }
                        } else if (this.source.format == 4) {
                            n18 = n & 0xFFFFFF;
                            for (n17 = 0; n17 < this.source.width; ++n17) {
                                n16 = this.source.pixels[n12++];
                                this.tintedPixels[n17] = (n3 * n16 & 0xFF00) << 16 | n18;
                            }
                        }
                        writableRaster.setDataElements(0, i, this.source.width, 1, this.tintedPixels);
                    }
                }
            } else {
                writableRaster.setDataElements(0, 0, this.source.width, this.source.height, this.source.pixels);
            }
            this.tinted = bl;
            this.tintedColor = n;
        }
    }
}

