/*
 * Decompiled with CFR 0.152.
 */
package krister.Ess;

import krister.Ess.allpass;
import krister.Ess.comb;
import krister.Ess.delay;

final class ReverbModel {
    public static final int numcombs = 8;
    public static final int numallpasses = 4;
    public static final float muted = 0.0f;
    public static final float fixedgain = 0.015f;
    public static final float scalewet = 1.0f;
    public static final float scaledry = 1.0f;
    public static final float scaledamp = 0.4f;
    public static final float scaleroom = 0.28f;
    public static final float offsetroom = 0.7f;
    public static final float initialroom = 0.5f;
    public static final float initialdamp = 0.5f;
    public static final float initialwet = 1.0f;
    public static final float initialdry = 0.0f;
    public static final float initialmode = 0.0f;
    public static final int initialpredelay = 0;
    public static final float freezemode = 0.5f;
    public int max_predelay_samps;
    public int[] combtuning = new int[]{1116, 1188, 1277, 1356, 1422, 1491, 1557, 1617};
    public int[] allpasstuning = new int[]{556, 441, 341, 225};
    private float gain;
    private float roomsize;
    private float roomsize1;
    private float damp;
    private float damp1;
    private float wet;
    private float dry;
    private float mode;
    private int predelay_samps;
    comb[] combf = new comb[8];
    allpass[] allpassf = new allpass[4];
    delay delayf = new delay();
    float[][] bufcomb = new float[8][];
    float[][] bufallpass = new float[4][];
    float[] bufdelay;

    ReverbModel(float f) {
        int n;
        for (n = 0; n < 8; ++n) {
            this.combtuning[n] = (int)((float)this.combtuning[n] * f / 44100.0f);
        }
        for (n = 0; n < 4; ++n) {
            this.allpasstuning[n] = (int)((float)this.allpasstuning[n] * f / 44100.0f);
        }
        for (n = 0; n < 8; ++n) {
            this.bufcomb[n] = new float[this.combtuning[n]];
            this.combf[n] = new comb();
            this.combf[n].setbuffer(this.bufcomb[n], this.combtuning[n]);
        }
        for (n = 0; n < 4; ++n) {
            this.bufallpass[n] = new float[this.allpasstuning[n]];
            this.allpassf[n] = new allpass();
            this.allpassf[n].setbuffer(this.bufallpass[n], this.allpasstuning[n]);
            this.allpassf[n].setfeedback(0.5f);
        }
        this.max_predelay_samps = (int)(f / 2.0f);
        this.bufdelay = new float[this.max_predelay_samps];
        this.delayf.setbuffer(this.bufdelay, this.max_predelay_samps);
        this.setwet(1.0f);
        this.setroomsize(0.5f);
        this.setdry(0.0f);
        this.setdamp(0.5f);
        this.setmode(0.0f);
        this.setpredelay(0);
    }

    void mute() {
        int n;
        if (this.getmode() >= 0.5f) {
            return;
        }
        for (n = 0; n < 8; ++n) {
            this.combf[n].mute();
        }
        for (n = 0; n < 4; ++n) {
            this.allpassf[n].mute();
        }
        this.delayf.mute();
    }

    void processreplace(float[] fArray, float[] fArray2, int n, long l, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (l-- > 0L) {
            int n5;
            float f = 0.0f;
            float f2 = fArray[n3 + n] * 2.0f * this.gain;
            for (n5 = 0; n5 < 8; ++n5) {
                f += this.combf[n5].process(f2);
            }
            for (n5 = 0; n5 < 4; ++n5) {
                f = this.allpassf[n5].process(f);
            }
            fArray2[n4 + n] = this.predelay_samps > 0 ? this.delayf.process(f) : f;
            n3 += n2;
            n4 += n2;
        }
    }

    void update() {
        int n;
        if (this.mode >= 0.5f) {
            this.roomsize1 = 1.0f;
            this.damp1 = 0.0f;
            this.gain = 0.0f;
        } else {
            this.roomsize1 = this.roomsize;
            this.damp1 = this.damp;
            this.gain = 0.015f;
        }
        for (n = 0; n < 8; ++n) {
            this.combf[n].setfeedback(this.roomsize1);
        }
        for (n = 0; n < 8; ++n) {
            this.combf[n].setdamp(this.damp1);
        }
    }

    void setroomsize(float f) {
        this.roomsize = f * 0.28f + 0.7f;
        this.update();
    }

    float getroomsize() {
        return (this.roomsize - 0.7f) / 0.28f;
    }

    void setdamp(float f) {
        this.damp = f * 0.4f;
        this.update();
    }

    float getdamp() {
        return this.damp / 0.4f;
    }

    void setwet(float f) {
        this.wet = f * 1.0f;
    }

    float getwet() {
        return this.wet / 1.0f;
    }

    void setdry(float f) {
        this.dry = f * 1.0f;
    }

    float getdry() {
        return this.dry / 1.0f;
    }

    void setmode(float f) {
        this.mode = f;
        this.update();
    }

    float getmode() {
        if (this.mode >= 0.5f) {
            return 1.0f;
        }
        return 0.0f;
    }

    void setpredelay(int n) {
        this.predelay_samps = Math.min(this.max_predelay_samps, Math.max(n, 0));
        this.delayf.setdelaysamps(this.predelay_samps);
    }

    int getpredelay() {
        return this.predelay_samps;
    }
}

