/*
 * Decompiled with CFR 0.152.
 */
package com.xplsv.controllers;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;
import java.io.FileInputStream;

public class FileController {
    byte[] data;
    int width;
    int height;

    public FileController() {
        this.destroy();
    }

    public void generateTextureInfo(String textureName, boolean AlphaChannel) {
        int[] pixels;
        Image textureFile = null;
        if (!textureName.endsWith("bmp")) {
            try {
                textureFile = Toolkit.getDefaultToolkit().getImage(textureName);
            }
            catch (NullPointerException e) {
                System.out.println(e);
            }
            while (this.width <= 0 || this.height <= 0) {
                this.width = textureFile.getWidth(null);
                this.height = textureFile.getHeight(null);
            }
            pixels = new int[this.width * this.height];
            try {
                new PixelGrabber(textureFile, 0, 0, this.width, this.height, pixels, 0, this.width).grabPixels();
                textureFile = null;
            }
            catch (InterruptedException e) {}
        } else {
            pixels = this.loadBitmapPixels(textureName);
        }
        if (!AlphaChannel) {
            this.data = new byte[pixels.length * 3];
            int y = this.height - 1;
            int pointer = 0;
            while (y >= 0) {
                int x = 0;
                while (x < this.width) {
                    this.data[pointer + 0] = (byte)(pixels[y * this.width + x] >> 16 & 0xFF);
                    this.data[pointer + 1] = (byte)(pixels[y * this.width + x] >> 8 & 0xFF);
                    this.data[pointer + 2] = (byte)(pixels[y * this.width + x] & 0xFF);
                    ++x;
                    pointer += 3;
                }
                --y;
            }
        } else {
            this.data = new byte[pixels.length * 4];
            int y = this.height - 1;
            int pointer = 0;
            while (y >= 0) {
                int x = 0;
                while (x < this.width) {
                    this.data[pointer + 3] = (byte)(pixels[y * this.width + x] >> 24 & 0xFF);
                    this.data[pointer + 0] = (byte)(pixels[y * this.width + x] >> 16 & 0xFF);
                    this.data[pointer + 1] = (byte)(pixels[y * this.width + x] >> 8 & 0xFF);
                    this.data[pointer + 2] = (byte)(pixels[y * this.width + x] & 0xFF);
                    ++x;
                    pointer += 4;
                }
                --y;
            }
        }
        pixels = null;
    }

    public int[] loadBitmapPixels(String file) {
        try {
            FileInputStream input = new FileInputStream(file);
            int bitmapFileHeaderLength = 14;
            int bitmapInfoHeaderLength = 40;
            byte[] bitmapFileHeader = new byte[bitmapFileHeaderLength];
            byte[] bitmapInfoHeader = new byte[bitmapInfoHeaderLength];
            input.read(bitmapFileHeader, 0, bitmapFileHeaderLength);
            input.read(bitmapInfoHeader, 0, bitmapInfoHeaderLength);
            int nSize = this.bytesToInt(bitmapFileHeader, 2);
            int nWidth = this.bytesToInt(bitmapInfoHeader, 4);
            int nHeight = this.bytesToInt(bitmapInfoHeader, 8);
            int nBiSize = this.bytesToInt(bitmapInfoHeader, 0);
            short nPlanes = this.bytesToShort(bitmapInfoHeader, 12);
            short nBitCount = this.bytesToShort(bitmapInfoHeader, 14);
            int nSizeImage = this.bytesToInt(bitmapInfoHeader, 20);
            int nCompression = this.bytesToInt(bitmapInfoHeader, 16);
            int nColoursUsed = this.bytesToInt(bitmapInfoHeader, 32);
            int nXPixelsMeter = this.bytesToInt(bitmapInfoHeader, 24);
            int nYPixelsMeter = this.bytesToInt(bitmapInfoHeader, 28);
            int nImportantColours = this.bytesToInt(bitmapInfoHeader, 36);
            if (nBitCount == 24) {
                int npad = nSizeImage / nHeight - nWidth * 3;
                npad = npad == 4 || npad < 0 ? 0 : npad;
                int nindex = 0;
                int[] ndata = new int[nHeight * nWidth];
                byte[] brgb = new byte[(nWidth + npad) * 3 * nHeight];
                input.read(brgb, 0, (nWidth + npad) * 3 * nHeight);
                int j = 0;
                while (j < nHeight) {
                    int i = 0;
                    while (i < nWidth) {
                        ndata[nWidth * (nHeight - j - 1) + i] = 0xFF000000 | (brgb[nindex + 2] & 0xFF) << 16 | (brgb[nindex + 1] & 0xFF) << 8 | brgb[nindex] & 0xFF;
                        nindex += 3;
                        ++i;
                    }
                    nindex += npad;
                    ++j;
                }
                brgb = null;
                input.close();
                this.width = nWidth;
                this.height = nHeight;
                return ndata;
            }
            if (nBitCount == 8) {
                int nNumColors;
                int n = nNumColors = nColoursUsed > 0 ? nColoursUsed : 1 << nBitCount;
                if (nSizeImage == 0) {
                    nSizeImage = (nWidth * nBitCount + 31 & 0xFFFFFFE0) >> 3;
                    nSizeImage *= nHeight;
                }
                int[] npalette = new int[nNumColors];
                byte[] bpalette = new byte[nNumColors * 4];
                input.read(bpalette, 0, nNumColors * 4);
                int nindex8 = 0;
                int n2 = 0;
                while (n2 < nNumColors) {
                    npalette[n2] = 0xFF000000 | (bpalette[nindex8 + 2] & 0xFF) << 16 | (bpalette[nindex8 + 1] & 0xFF) << 8 | bpalette[nindex8 + 0] & 0xFF;
                    nindex8 += 4;
                    ++n2;
                }
                int npad8 = nSizeImage / nHeight - nWidth;
                int[] ndata8 = new int[nWidth * nHeight];
                byte[] bdata = new byte[(nWidth + npad8) * nHeight];
                input.read(bdata, 0, (nWidth + npad8) * nHeight);
                nindex8 = 0;
                int j8 = 0;
                while (j8 < nHeight) {
                    int i8 = 0;
                    while (i8 < nWidth) {
                        ndata8[nWidth * (nHeight - j8 - 1) + i8] = npalette[bdata[nindex8] & 0xFF];
                        ++nindex8;
                        ++i8;
                    }
                    nindex8 += npad8;
                    ++j8;
                }
                input.close();
                this.width = nWidth;
                this.height = nHeight;
                return ndata8;
            }
            System.out.println("Not a 24-bit or 8-bit Windows Bitmap, aborting...");
            input.close();
        }
        catch (Exception e) {
            System.out.println("Caught exception in loadbitmap!");
        }
        return null;
    }

    public int bytesToInt(byte[] bytes, int index) {
        return (bytes[index + 3] & 0xFF) << 24 | (bytes[index + 2] & 0xFF) << 16 | (bytes[index + 1] & 0xFF) << 8 | bytes[index + 0] & 0xFF;
    }

    public short bytesToShort(byte[] bytes, int index) {
        return (short)((bytes[index + 1] & 0xFF) << 8 | bytes[index + 0] & 0xFF);
    }

    public void destroy() {
        this.data = null;
        this.width = -1;
        this.height = -1;
    }
}

