

/*###############################################
# Shader Configuration
################################################*/

#pragma Config

	#define BW_VERTEX_POSITION 	1
	#define BW_VERTEX_NORMAL 	2
	#define BW_VERTEX_UV 		4
	#define BW_VERTEX_COLOR 	8

	// Vertex structure 
	VertexProfileCreate(3);
	VertexProfileSet(0,0,3,BW_VERTEX_POSITION,0);
	VertexProfileSet(1,12,3,BW_VERTEX_NORMAL,0);
	VertexProfileSet(2,24,3,BW_VERTEX_UV,0);

	VertexShaderVersion(2);
	PixelShaderVersion(2);

/*###############################################
# Vertex Shader
################################################*/
#pragma HLSL_VS

// Matrix
float4x4 bw_ModelViewMatrix;	
float4x4 bw_ModelViewProjectionMatrix;
float4x4 bw_NormalMatrix;
float4x4 bw_ObjectMatrix;

float4 bw_CameraPos;


// Material Color
float4	bwMaterialDiffuse;


struct VS_INPUT
{
	float3 position  : POSITION;
	float3 normal    : NORMAL;
	float2 texcoord0 : TEXCOORD0;
};


struct VS_OUTPUT
{
	float4 hposition	:POSITION;
	float4 Color		:COLOR0;
	float2 texcoord0	:TEXCOORD0;
	float3 R			:TEXCOORD1;
	float  z			:TEXCOORD2;
};


VS_OUTPUT main( VS_INPUT IN )
{
	VS_OUTPUT OUT;
	OUT.texcoord0 = IN.texcoord0;
	OUT.hposition = mul(float4(IN.position.xyz,1.0),bw_ModelViewProjectionMatrix);
	OUT.Color = 1.0;

	float4 v_Pos = mul(float4(IN.position.xyz,1.0),bw_ObjectMatrix);
	float4 v_Nor = normalize(mul(float4(IN.normal.xyz,0.0),bw_ObjectMatrix));
	OUT.R = reflect(normalize(v_Pos.xyz-bw_CameraPos.xyz),v_Nor.xyz);

	
	float3 diffuse_col=mul(float4(IN.normal.xyz,0.0) ,bw_NormalMatrix).zzz; 


	OUT.Color= bwMaterialDiffuse*float4(diffuse_col,1);

	return OUT;
}


/*###############################################
# Pixel Shader
################################################*/

#pragma HLSL_PS

struct VS_OUTPUT
{
	float4 hposition	:POSITION;
	float4 Color		:COLOR0;
	float2 texcoord0	:TEXCOORD0;
	float3 R			:TEXCOORD1;
	float  z			:TEXCOORD2;
};

struct PS_OUTPUT
{
	float4 color : COLOR;
};


sampler texture_1:register(s0);

PS_OUTPUT main( VS_OUTPUT IN )
{
	PS_OUTPUT OUT;	
	
	float4 cube = texCUBE(texture_1,IN.R);

	
	OUT.color =  IN.Color*cube;	
	
	return OUT;
}


#end