#!/usr/bin/cube
open /dev/ttyUSB1

clear
flush

proc phase1 {TIME} {
	for {set x 0} {$x < 5} {incr x} {
		for {set z 0} {$z < 5} {incr z} {
			led $x 1 $z 1	
		}
	}
	flush
	sleep $TIME
	for {set y 4} {$y >= 1} {incr y -1} {
		if {$y < 4} {
			led 2 [expr $y+1] 2 0
		}
		led 2 $y 2 8
		flush
		sleep $TIME
		
	}
	for {set x 1} {$x < 4} {incr x} {
		for {set z 1} {$z < 4} {incr z} {
			led $x 2 $z 1	
			led $x 1 $z 0
		}
	}
	
	flush
	sleep $TIME
	for {set x 0} {$x < 5} {incr x} {
		for {set z 0} {$z < 5} {incr z} {
			led $x 2 $z 1	
			led $x 1 $z 0	
		}
	}
	
	flush
	sleep $TIME
	for {set x 1} {$x < 4} {incr x} {
		for {set z 1} {$z < 4} {incr z} {
			led $x 2 $z 0	
			led $x 1 $z 1
		}
	}
	
	flush
	sleep $TIME
	for {set x 0} {$x < 5} {incr x} {
		for {set z 0} {$z < 5} {incr z} {
			led $x 2 $z 0	
			led $x 1 $z 1	
		}
	}
	flush
	sleep $TIME
}

proc phase2 {TIME} {
	for {set x 0} {$x < 5} {incr x} {
		led $x 2 4 1
		led $x 1 4 0
		led $x 2 0 1
		led $x 1 0 0
		led $x 1 2 0
		led $x 0 2 1
	}
	flush
	sleep $TIME
	for {set x 0} {$x < 5} {incr x} {
		led $x 1 1 0
		led $x 1 3 0
		led $x 1 2 1
		led $x 2 4 0
		led $x 2 3 1
		led $x 2 0 0
		led $x 2 1 1
	}
	flush
	sleep $TIME
	for {set x 0} {$x < 5} {incr x} {
		led $x 2 1 0
		led $x 2 3 0
		led $x 2 2 1
	}
	flush
	sleep $TIME
	for {set x 0} {$x < 5} {incr x} {
		led $x 3 2 1
	}
	flush
	sleep $TIME
	for {set x 0} {$x < 5} {incr x} {
		led $x 4 2 1
	}
	flush
	sleep $TIME
	for {set x 0} {$x < 5} {incr x} {
		for {set y 0} {$y < 5} {incr y} {
			led $x $y 2 8
		}
	}
	flush
	for {set x 0} {$x < 5} {incr x} {
		for {set y 0} {$y < 5} {incr y} {
			led $x $y 2 0
		}
	}
	flush
	for {set p 0} {$p < 4} {incr p} {
		for {set x 0} {$x < 5} {incr x} {
			for {set y 0} {$y < 5} {incr y} {
				led $x $y 2 $p 
			}
		}
		flush
		sleep 150
	}
	for {set p 4} {$p >= 1} {incr p -1} {
		for {set x 0} {$x < 5} {incr x} {
			for {set y 0} {$y < 5} {incr y} {
				led $x $y 2 $p 
			}
		}
		flush
		sleep 150
	}
}

proc phase3 {TIME} {
	for {set x 0} {$x < 5} {incr x} {
		led $x 4 2 0
		led $x 3 2 0
		led $x 3 1 1
		led $x 2 1 1

		led $x 0 2 0
		led $x 1 2 0
		led $x 1 3 1
		led $x 2 3 1
	}
	flush
	sleep $TIME
	for {set x 0} {$x < 5} {incr x} {
		led $x 3 1 0
		led $x 2 0 1

		led $x 1 3 0
		led $x 2 4 1
	}
	flush
	sleep $TIME
}

proc phase4 {TIME} {
	for {set z 0} {$z < 5} {incr z} {
		led 4 2 $z 0
		led 3 2 $z 0
		led 3 3 $z 1
		led 2 3 $z 1

		led 0 2 $z 0
		led 1 2 $z 0
		led 1 1 $z 1
		led 2 1 $z 1
	}
	flush
	sleep $TIME
	for {set z 0} {$z < 5} {incr z} {
		led 3 3 $z 0
		led 2 4 $z 1

		led 1 1 $z 0
		led 2 0 $z 1

	}
	flush
	sleep $TIME
}

proc phase5 {TIME} {
	for {set y 0} {$y < 5} {incr y} {
		led 2 $y 4 0
		led 2 $y 3 0
		led 1 $y 3 1
		led 1 $y 2 1

		led 2 $y 0 0
		led 2 $y 1 0
		led 3 $y 1 1
		led 3 $y 2 1
	}
	flush
	sleep $TIME
	for {set y 0} {$y < 5} {incr y} {
		led 1 $y 3 0
		led 3 $y 1 0

		led 4 $y 2 1
		led 0 $y 2 1
	}
	flush
	sleep $TIME
}

proc phase6 {TIME} {
	for {set x 0} {$x < 5} {incr x} {
		led $x 4 2 0
		led $x 3 2 0
		led $x 3 1 1
		led $x 2 1 1

		led $x 0 2 0
		led $x 1 2 0
		led $x 2 3 1
		led $x 1 3 1
	}
	flush
	sleep $TIME
	for {set x 0} {$x < 5} {incr x} {
		led $x 3 1 0
		led $x 1 3 0
		
		led $x 2 0 1
		led $x 2 4 1
	}
	flush
	sleep $TIME
}

proc oldphase7 {TIME} {
	led 2 2 2 0
	led 2 1 2 1
	flush
	sleep $TIME
	for {set x 1} {$x < 4} {incr x} {
		for {set z 1} {$z < 4} {incr z} {
			led $x 2 $z 0
			led $x 1 $z 1
		}
	}	
	flush
	sleep $TIME
	for {set x 0} {$x < 5} {incr x} {
		for {set z 0} {$z < 5} {incr z} {
			led $x 2 $z 0
			led $x 1 $z 1
		}
	}	
	flush
	sleep $TIME
}

proc phase7 {TIME} {
	for {set x 0} {$x < 5} {incr x} {
		for {set z 0} {$z < 5} {incr z} {
			led $x 2 $z 0
		}
	}	
	for {set x 1} {$x < 4} {incr x} {
		for {set z 1} {$z < 4} {incr z} {
			led $x 2 $z 1
		}
	}	
	flush
	sleep $TIME
	for {set x 1} {$x < 4} {incr x} {
		for {set z 1} {$z < 4} {incr z} {
			led $x 2 $z 0
		}
	}	
	led 2 2 2 1
	flush
	sleep $TIME
	for {set p 1} {$p < 8} {incr p} {
		led 2 2 2 $p
		flush
		sleep 20
	}
	for {set p 8} {$p >= 0} {incr p -1} {
		led 2 2 2 $p
		flush
		sleep 20
	}


}
phase1 300
phase2 300
phase3 300
phase4 300
phase5 300
phase6 300
phase7 300
