/*
 * Decompiled with CFR 0.152.
 */
package k2dp;

import com.nokia.mid.ui.DeviceControl;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Sprite3D;
import k2dp.Donut;
import k2dp.Effect3D;
import k2dp.End3D;
import k2dp.Intro;
import k2dp.MiniFontPlotter;
import k2dp.ParticleEffect;
import k2dp.Pyramid;
import k2dp.Ringe;
import k2dp.Upscroller;

public class DemoScreen
extends GameCanvas {
    public String osd = "";
    public static boolean emulator = true;
    int[][] sequence;
    private int currSeq;
    int vX;
    int vY;
    int vW;
    int vH;
    public static Sprite3D dummySprite;
    public static Camera dummyCamera;
    boolean pause;
    boolean screenshot;
    Image scrpic;
    int[] scrrgb;
    Graphics3D g3d;
    Effect3D[] effects;
    Intro intro;
    Upscroller upscroller;
    ParticleEffect particles;
    Ringe ringe;
    Donut donut;
    MiniFontPlotter miniFont;
    End3D end3d;
    Pyramid pyramid;
    int currFx;
    int frameCounter;
    static /* synthetic */ Class class$0;

    static {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("k2dp.DemoScreen");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Image tmp = Image.createImage((InputStream)clazz.getResourceAsStream("/spacer.png"));
            dummySprite = new Sprite3D(false, new Image2D(100, (Object)tmp), new Appearance());
            dummyCamera = new Camera();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected DemoScreen() {
        super(true);
        int[][] nArrayArray = new int[15][];
        nArrayArray[0] = new int[]{591, 1, -1};
        nArrayArray[1] = new int[]{783, 3, -1};
        nArrayArray[2] = new int[]{902, 1, 2};
        nArrayArray[3] = new int[]{1019, 1, 3};
        nArrayArray[4] = new int[]{1245, 2, -1};
        nArrayArray[5] = new int[]{1350, 3, -1};
        nArrayArray[6] = new int[]{1500, 2, 2};
        nArrayArray[7] = new int[]{1650, 2, 3};
        nArrayArray[8] = new int[]{1700, 3, -1};
        nArrayArray[9] = new int[]{1750, 3, 5};
        nArrayArray[10] = new int[]{1800, 2, 3};
        nArrayArray[11] = new int[]{1850, 1, 2};
        nArrayArray[12] = new int[]{1900, 2, 1};
        nArrayArray[13] = new int[]{1950, 4, -1};
        int[] nArray = new int[3];
        nArray[0] = -1;
        nArray[2] = -1;
        nArrayArray[14] = nArray;
        this.sequence = nArrayArray;
        this.currSeq = 0;
        this.vX = 0;
        this.vY = 0;
        this.vW = 0;
        this.vH = 0;
        this.pause = false;
        this.screenshot = false;
        this.setFullScreenMode(true);
        this.vX = 0;
        this.vY = 0;
        this.vW = this.getWidth();
        this.vH = this.getHeight();
        this.g3d = Graphics3D.getInstance();
        try {
            this.particles = new ParticleEffect();
            this.miniFont = new MiniFontPlotter();
            this.ringe = new Ringe(this.getWidth(), this.getHeight(), this.particles, this.miniFont);
            this.donut = new Donut(this.getWidth(), this.getHeight(), this.miniFont);
            this.end3d = new End3D(this.getWidth(), this.getHeight());
            this.upscroller = new Upscroller(this.getWidth(), this.getHeight(), this.end3d);
            this.intro = new Intro();
            this.pyramid = new Pyramid(this.getWidth(), this.getHeight(), this.miniFont);
            this.effects = new Effect3D[]{this.intro, this.ringe, this.donut, this.pyramid, this.upscroller};
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Timer timer = new Timer();
        timer.schedule((TimerTask)new RefreshTask(), 0L, 40L);
    }

    private void print(Group n, int ident) {
        int k = 0;
        while (k < ident) {
            System.out.print(" ");
            ++k;
        }
        System.out.println(n + " : " + n.getUserID());
        k = 0;
        while (k < n.getChildCount()) {
            Node c = n.getChild(k);
            if (c instanceof Group) {
                this.print((Group)c, ident + 1);
            } else {
                int j = 0;
                while (j < ident + 1) {
                    System.out.print(" ");
                    ++j;
                }
                System.out.println(c + " : " + c.getUserID());
            }
            ++k;
        }
    }

    public void play() {
    }

    public void paint(Graphics g) {
        if (this.screenshot) {
            this.scrpic = Image.createImage((int)this.vW, (int)this.vH);
            g = this.scrpic.getGraphics();
        }
        if (!this.pause) {
            if (this.currFx < this.effects.length) {
                Effect3D fx = this.effects[this.currFx];
                this.g3d.bindTarget((Object)g);
                this.g3d.setViewport(this.vX, this.vY, this.vW, this.vH);
                fx.paint(this.g3d);
                this.g3d.releaseTarget();
                fx.paint2D(g);
                ++this.frameCounter;
                if (this.sequence[this.currSeq][0] == this.frameCounter) {
                    if (emulator) {
                        System.out.println("{" + this.frameCounter + "," + this.sequence[this.currSeq][1] + "," + this.sequence[this.currSeq][2] + "}, //seq " + this.frameCounter / 25);
                    }
                    this.currFx = this.sequence[this.currSeq][1];
                    this.effects[this.currFx].setEffect(this.sequence[this.currSeq][2]);
                    ++this.currSeq;
                    if (this.currSeq == this.sequence.length) {
                        this.currSeq = 0;
                        this.frameCounter = 0;
                    }
                }
                if (!emulator) {
                    DeviceControl.setLights((int)0, (int)100);
                }
            } else {
                g.setColor(0);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
        if (this.screenshot) {
            try {
                String path = System.getProperty("fileconn.dir.private");
                path = "file:///" + FileSystemRegistry.listRoots().nextElement().toString();
                FileConnection con = (FileConnection)Connector.open((String)(String.valueOf(path) + "/screenshot.dat"));
                OutputStream os = Connector.openOutputStream((String)con.getURL());
                this.scrrgb = new int[this.vW * this.vH];
                this.scrpic.getRGB(this.scrrgb, 0, this.vW, 0, 0, this.vW, this.vH);
                int y = 0;
                while (y < this.vH) {
                    int x = 0;
                    while (x < this.vW) {
                        int i = x + y * this.vW;
                        os.write(this.scrrgb[i] >> 24);
                        os.write(this.scrrgb[i] >> 16 & 0xFF);
                        os.write(this.scrrgb[i] >> 8 & 0xFF);
                        os.write(this.scrrgb[i] & 0xFF);
                        ++x;
                    }
                    ++y;
                }
                System.out.println("wrote img");
                os.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.screenshot = false;
        }
        if (this.osd != null && this.osd.length() != 0) {
            g.setColor(0);
            g.drawString(this.osd, 1, 1, 0);
            g.setColor(0xFFFFFF);
            g.drawString(this.osd, 0, 0, 0);
        }
    }

    public void keyPressed(int keycode) {
        if (keycode >= 48 && keycode <= 57) {
            this.effects[this.currFx].setEffect(keycode - 48);
            if (emulator) {
                System.out.println("{" + this.frameCounter + "," + this.currFx + "," + (keycode - 48) + "}, //keypress " + this.frameCounter / 25);
            }
        }
        if (keycode == -6) {
            ++this.currFx;
            this.pause = false;
            if (this.currFx == this.effects.length) {
                this.currFx = 0;
            }
            if (emulator) {
                System.out.println("{" + this.frameCounter + "," + this.currFx + ",-1}, //next part");
            }
        }
        if (keycode == 42) {
            boolean bl = this.pause = !this.pause;
        }
        if (keycode == 35) {
            this.screenshot = true;
        }
    }

    private class RefreshTask
    extends TimerTask {
        private RefreshTask() {
        }

        public void run() {
            DemoScreen.this.repaint();
        }
    }
}

