/*
 * Decompiled with CFR 0.152.
 */
package idx3d;

import idx3d.idx3d_Camera;
import idx3d.idx3d_CoreObject;
import idx3d.idx3d_Environment;
import idx3d.idx3d_Light;
import idx3d.idx3d_Material;
import idx3d.idx3d_Matrix;
import idx3d.idx3d_Object;
import idx3d.idx3d_RenderPipeline;
import idx3d.idx3d_Texture;
import idx3d.idx3d_Triangle;
import idx3d.idx3d_Vector;
import java.awt.Dimension;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Hashtable;

public final class idx3d_Scene
extends idx3d_CoreObject {
    public static final String version = "3.1.001";
    public static final String release = "29.05.2000";
    public idx3d_RenderPipeline renderPipeline;
    public int width;
    public int height;
    public idx3d_Environment environment = new idx3d_Environment();
    public idx3d_Camera defaultCamera = idx3d_Camera.FRONT();
    public idx3d_Object[] object;
    public idx3d_Light[] light;
    public int objects;
    public int lights;
    private boolean objectsNeedRebuild = true;
    private boolean lightsNeedRebuild = true;
    protected boolean preparedForRendering;
    public idx3d_Vector normalizedOffset = new idx3d_Vector(0.0f, 0.0f, 0.0f);
    public float normalizedScale = 1.0f;
    private static boolean instancesRunning;
    public Hashtable objectData = new Hashtable();
    public Hashtable lightData = new Hashtable();
    public Hashtable materialData = new Hashtable();
    public Hashtable cameraData = new Hashtable();

    public void rebuild() {
        int n;
        Enumeration enumeration;
        if (this.objectsNeedRebuild) {
            this.objectsNeedRebuild = false;
            this.objects = this.objectData.size();
            this.object = new idx3d_Object[this.objects];
            enumeration = this.objectData.elements();
            n = this.objects - 1;
            while (n >= 0) {
                this.object[n] = (idx3d_Object)enumeration.nextElement();
                this.object[n].id = n;
                this.object[n].rebuild();
                --n;
            }
        }
        if (this.lightsNeedRebuild) {
            this.lightsNeedRebuild = false;
            this.lights = this.lightData.size();
            this.light = new idx3d_Light[this.lights];
            enumeration = this.lightData.elements();
            n = this.lights - 1;
            while (n >= 0) {
                this.light[n] = (idx3d_Light)enumeration.nextElement();
                --n;
            }
        }
    }

    public void normalize() {
        this.objectsNeedRebuild = true;
        this.rebuild();
        if (this.objects == 0) {
            return;
        }
        this.matrix = new idx3d_Matrix();
        this.normalmatrix = new idx3d_Matrix();
        idx3d_Vector idx3d_Vector2 = this.object[0].max();
        idx3d_Vector idx3d_Vector3 = this.object[0].min();
        int n = 0;
        while (n < this.objects) {
            idx3d_Vector idx3d_Vector4 = this.object[n].max();
            idx3d_Vector idx3d_Vector5 = this.object[n].min();
            if (idx3d_Vector4.x > idx3d_Vector2.x) {
                idx3d_Vector2.x = idx3d_Vector4.x;
            }
            if (idx3d_Vector4.y > idx3d_Vector2.y) {
                idx3d_Vector2.y = idx3d_Vector4.y;
            }
            if (idx3d_Vector4.z > idx3d_Vector2.z) {
                idx3d_Vector2.z = idx3d_Vector4.z;
            }
            if (idx3d_Vector5.x < idx3d_Vector3.x) {
                idx3d_Vector3.x = idx3d_Vector5.x;
            }
            if (idx3d_Vector5.y < idx3d_Vector3.y) {
                idx3d_Vector3.y = idx3d_Vector5.y;
            }
            if (idx3d_Vector5.z < idx3d_Vector3.z) {
                idx3d_Vector3.z = idx3d_Vector5.z;
            }
            ++n;
        }
        float f = idx3d_Vector2.x - idx3d_Vector3.x;
        float f2 = idx3d_Vector2.y - idx3d_Vector3.y;
        float f3 = idx3d_Vector2.z - idx3d_Vector3.z;
        float f4 = (idx3d_Vector2.x + idx3d_Vector3.x) / 2.0f;
        float f5 = (idx3d_Vector2.y + idx3d_Vector3.y) / 2.0f;
        float f6 = (idx3d_Vector2.z + idx3d_Vector3.z) / 2.0f;
        float f7 = f > f2 ? f : f2;
        f7 = f3 > f7 ? f3 : f7;
        this.normalizedOffset = new idx3d_Vector(f4, f5, f6);
        this.normalizedScale = 2.0f / f7;
        this.shift(this.normalizedOffset.reverse());
        this.scale(this.normalizedScale);
    }

    void prepareForRendering() {
        if (this.preparedForRendering) {
            return;
        }
        this.preparedForRendering = true;
        System.out.println(">> Preparing structures for realtime rendering ...   ");
        this.rebuild();
        this.renderPipeline.buildLightMap();
        this.printSceneInfo();
    }

    public final boolean antialias() {
        return this.renderPipeline.screen.antialias;
    }

    public idx3d_Light light(String string) {
        return (idx3d_Light)this.lightData.get(string);
    }

    public void addObject(String string, idx3d_Object idx3d_Object2) {
        idx3d_Object2.name = string;
        this.objectData.put(string, idx3d_Object2);
        idx3d_Object2.parent = this;
        this.objectsNeedRebuild = true;
    }

    public float getFPS() {
        return this.renderPipeline.getFPS();
    }

    private idx3d_Scene() {
    }

    public idx3d_Scene(int n, int n2) {
        this.showInfo();
        this.width = n;
        this.height = n2;
        this.renderPipeline = new idx3d_RenderPipeline(this, n, n2);
    }

    public void addMaterial(String string, idx3d_Material idx3d_Material2) {
        this.materialData.put(string, idx3d_Material2);
    }

    public void setBackgroundColor(int n) {
        this.environment.bgcolor = n;
    }

    public void setAmbient(int n) {
        this.environment.ambient = n;
    }

    public void printSceneInfo() {
        System.out.println(">> | Objects   : " + this.objects);
        System.out.println(">> | Vertices  : " + this.countVertices());
        System.out.println(">> | Triangles : " + this.countTriangles());
    }

    public final void setAntialias(boolean bl) {
        this.renderPipeline.setAntialias(bl);
    }

    public void removeLight(String string) {
        this.lightData.remove(string);
        this.lightsNeedRebuild = true;
        this.preparedForRendering = false;
    }

    public final Image getImage() {
        return this.renderPipeline.screen.getImage();
    }

    public void removeAllObjects() {
        this.objectData = new Hashtable();
        this.objectsNeedRebuild = true;
        this.rebuild();
    }

    public int countTriangles() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.objects) {
            n += this.object[n2].triangles;
            ++n2;
        }
        return n;
    }

    public idx3d_Triangle identifyTriangleAt(int n, int n2) {
        int n3;
        if (!this.renderPipeline.useIdBuffer) {
            return null;
        }
        if (n < 0 || n >= this.width) {
            return null;
        }
        if (n2 < 0 || n2 >= this.height) {
            return null;
        }
        int n4 = n + this.renderPipeline.screen.w * n2;
        if (this.renderPipeline.screen.antialias) {
            n4 *= 2;
        }
        if ((n3 = this.renderPipeline.idBuffer[n4]) < 0) {
            return null;
        }
        return this.object[n3 >> 16].triangle[n3 & 0xFFFF];
    }

    public idx3d_Material material(String string) {
        return (idx3d_Material)this.materialData.get(string);
    }

    public int countVertices() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.objects) {
            n += this.object[n2].vertices;
            ++n2;
        }
        return n;
    }

    public void removeObject(String string) {
        this.objectData.remove(string);
        this.objectsNeedRebuild = true;
        this.preparedForRendering = false;
    }

    public void setBackground(idx3d_Texture idx3d_Texture2) {
        this.environment.setBackground(idx3d_Texture2);
    }

    public void removeMaterial(String string) {
        this.materialData.remove(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<scene>\r\n");
        int n = 0;
        while (n < this.objects) {
            stringBuffer.append(this.object[n].toString());
            ++n;
        }
        return stringBuffer.toString();
    }

    public void removeCamera(String string) {
        this.cameraData.remove(string);
    }

    public void useIdBuffer(boolean bl) {
        this.renderPipeline.useIdBuffer(bl);
    }

    public Dimension size() {
        return new Dimension(this.width, this.height);
    }

    public void resize(int n, int n2) {
        if (this.width == n && this.height == n2) {
            return;
        }
        this.width = n;
        this.height = n2;
        this.renderPipeline.resize(n, n2);
    }

    public void addCamera(String string, idx3d_Camera idx3d_Camera2) {
        this.cameraData.put(string, idx3d_Camera2);
    }

    public idx3d_Object identifyObjectAt(int n, int n2) {
        idx3d_Triangle idx3d_Triangle2 = this.identifyTriangleAt(n, n2);
        if (idx3d_Triangle2 == null) {
            return null;
        }
        return idx3d_Triangle2.parent;
    }

    public void showInfo() {
        if (instancesRunning) {
            return;
        }
        System.out.println();
        System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        System.out.println(" idx3d Kernel " + version + " [Build " + release + "]");
        System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        System.out.println(" (c)1999 by Peter Walser, all rights reserved.");
        System.out.println(" http://www2.active.ch/~proxima/idx3d");
        System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        instancesRunning = true;
    }

    public final void render(idx3d_Camera idx3d_Camera2) {
        this.renderPipeline.render(idx3d_Camera2);
    }

    public final void render() {
        this.renderPipeline.render(this.defaultCamera);
    }

    public void addLight(String string, idx3d_Light idx3d_Light2) {
        this.lightData.put(string, idx3d_Light2);
        this.lightsNeedRebuild = true;
    }

    public idx3d_Camera camera(String string) {
        return (idx3d_Camera)this.cameraData.get(string);
    }

    public idx3d_Object object(String string) {
        return (idx3d_Object)this.objectData.get(string);
    }
}

