/*
 * Decompiled with CFR 0.152.
 */
package idx3d;

import idx3d.idx3d_Color;
import idx3d.idx3d_Lightmap;
import idx3d.idx3d_Material;
import idx3d.idx3d_Math;
import idx3d.idx3d_RenderPipeline;
import idx3d.idx3d_Screen;
import idx3d.idx3d_Texture;
import idx3d.idx3d_Triangle;
import idx3d.idx3d_Vertex;

public final class idx3d_Rasterizer {
    private boolean materialLoaded;
    private boolean lightmapLoaded;
    public boolean ready;
    private int color;
    private int currentColor;
    private int transparency;
    private int reflectivity;
    private int refraction;
    private idx3d_Texture texture;
    private int[] envmap;
    private int[] diffuse;
    private int[] specular;
    private short[] refractionMap;
    private int tw;
    private int th;
    private int tbitW;
    private int tbitH;
    private int mode;
    private int F;
    private int W = 1;
    private int P = 2;
    private int E = 4;
    private int T = 8;
    private int SHADED = this.P | this.E | this.T;
    idx3d_Vertex p1;
    idx3d_Vertex p2;
    idx3d_Vertex p3;
    idx3d_Vertex tempVertex;
    private int bkgrd;
    private int c;
    private int s;
    private int lutID;
    private int r;
    private int x1;
    private int x2;
    private int x3;
    private int x4;
    private int y1;
    private int y2;
    private int y3;
    private int z1;
    private int z2;
    private int z3;
    private int z4;
    private int x;
    private int y;
    private int z;
    private int k;
    private int dx;
    private int dy;
    private int dz;
    private int offset;
    private int pos;
    private int temp;
    private int xL;
    private int xR;
    private int xBase;
    private int zBase;
    private int xMax;
    private int yMax;
    private int dxL;
    private int dxR;
    private int dzBase;
    private int nx1;
    private int nx2;
    private int nx3;
    private int nx4;
    private int ny1;
    private int ny2;
    private int ny3;
    private int ny4;
    private int nxBase;
    private int nyBase;
    private int dnx4;
    private int dny4;
    private int dnx;
    private int dny;
    private int nx;
    private int ny;
    private int dnxBase;
    private int dnyBase;
    private int tx1;
    private int tx2;
    private int tx3;
    private int tx4;
    private int ty1;
    private int ty2;
    private int ty3;
    private int ty4;
    private int txBase;
    private int tyBase;
    private int dtx4;
    private int dty4;
    private int dtx;
    private int dty;
    private int tx;
    private int ty;
    private int dtxBase;
    private int dtyBase;
    idx3d_Screen screen;
    int[] zBuffer;
    int[] idBuffer;
    int width;
    int height;
    boolean useIdBuffer;
    final int zFar = 0xFFFFFFF;
    int currentId;

    private void renderLinePET() {
        this.x = this.xL;
        while (this.x < this.xR) {
            this.pos = this.x + this.offset;
            if (this.z < this.zBuffer[this.pos]) {
                this.lutID = (this.nx >> 16 & 0xFF) + ((this.ny >> 16 & 0xFF) << 8);
                this.bkgrd = this.screen.p[this.pos];
                this.c = this.texture.pixel[(this.tx >> 16 & this.tw) + ((this.ty >> 16 & this.th) << this.tbitW)];
                this.c = idx3d_Color.multiply(this.c, this.diffuse[this.lutID]);
                this.s = idx3d_Color.add(this.specular[this.lutID], this.envmap[this.lutID]);
                this.s = idx3d_Color.scale(this.s, this.reflectivity);
                this.c = idx3d_Color.transparency(this.bkgrd, this.c, this.transparency);
                this.c = idx3d_Color.add(this.c, this.s);
                this.screen.p[this.pos] = 0xFF000000 | this.c;
                this.zBuffer[this.pos] = this.z;
                if (this.useIdBuffer) {
                    this.idBuffer[this.pos] = this.currentId;
                }
            }
            this.z += this.dz;
            this.nx += this.dnx;
            this.ny += this.dny;
            this.tx += this.dtx;
            this.ty += this.dty;
            ++this.x;
        }
    }

    public void loadLightmap(idx3d_Lightmap idx3d_Lightmap2) {
        if (idx3d_Lightmap2 == null) {
            return;
        }
        this.diffuse = idx3d_Lightmap2.diffuse;
        this.specular = idx3d_Lightmap2.specular;
        this.lightmapLoaded = true;
        this.ready = this.lightmapLoaded && this.materialLoaded;
    }

    private void drawLine(idx3d_Vertex idx3d_Vertex2, idx3d_Vertex idx3d_Vertex3, int n) {
        if ((idx3d_Vertex2.clipcode & idx3d_Vertex3.clipcode) != 0) {
            return;
        }
        this.dx = Math.abs(idx3d_Vertex2.x - idx3d_Vertex3.x);
        this.dy = Math.abs(idx3d_Vertex2.y - idx3d_Vertex3.y);
        this.dz = 0;
        if (this.dx > this.dy) {
            if (idx3d_Vertex2.x > idx3d_Vertex3.x) {
                idx3d_Vertex idx3d_Vertex4 = idx3d_Vertex2;
                idx3d_Vertex2 = idx3d_Vertex3;
                idx3d_Vertex3 = idx3d_Vertex4;
            }
            if (this.dx > 0) {
                this.dz = (idx3d_Vertex3.z - idx3d_Vertex2.z) / this.dx;
                this.dy = (idx3d_Vertex3.y - idx3d_Vertex2.y << 16) / this.dx;
            }
            this.z = idx3d_Vertex2.z;
            this.y = idx3d_Vertex2.y << 16;
            this.x = idx3d_Vertex2.x;
            while (this.x <= idx3d_Vertex3.x) {
                this.y2 = this.y >> 16;
                if (idx3d_Math.inrange(this.x, 0, this.width - 1) && idx3d_Math.inrange(this.y2, 0, this.height - 1)) {
                    this.offset = this.y2 * this.width;
                    if (this.z < this.zBuffer[this.x + this.offset]) {
                        if (!this.screen.antialias) {
                            this.screen.p[this.x + this.offset] = n;
                            this.zBuffer[this.x + this.offset] = this.z;
                        } else {
                            this.screen.p[this.x + this.offset] = n;
                            this.screen.p[this.x + this.offset + 1] = n;
                            this.screen.p[this.x + this.offset + this.width] = n;
                            this.screen.p[this.x + this.offset + this.width + 1] = n;
                            this.zBuffer[this.x + this.offset] = this.z;
                        }
                    }
                    if (this.useIdBuffer) {
                        this.idBuffer[this.x + this.offset] = this.currentId;
                    }
                }
                this.z += this.dz;
                this.y += this.dy;
                ++this.x;
            }
            return;
        }
        if (idx3d_Vertex2.y > idx3d_Vertex3.y) {
            idx3d_Vertex idx3d_Vertex5 = idx3d_Vertex2;
            idx3d_Vertex2 = idx3d_Vertex3;
            idx3d_Vertex3 = idx3d_Vertex5;
        }
        if (this.dy > 0) {
            this.dz = (idx3d_Vertex3.z - idx3d_Vertex2.z) / this.dy;
            this.dx = (idx3d_Vertex3.x - idx3d_Vertex2.x << 16) / this.dy;
        }
        this.z = idx3d_Vertex2.z;
        this.x = idx3d_Vertex2.x << 16;
        this.y = idx3d_Vertex2.y;
        while (this.y <= idx3d_Vertex3.y) {
            this.x2 = this.x >> 16;
            if (idx3d_Math.inrange(this.x2, 0, this.width - 1) && idx3d_Math.inrange(this.y, 0, this.height - 1)) {
                this.offset = this.y * this.width;
                if (this.z < this.zBuffer[this.x2 + this.offset]) {
                    if (!this.screen.antialias) {
                        this.screen.p[this.x2 + this.offset] = n;
                        this.zBuffer[this.x2 + this.offset] = this.z;
                    } else {
                        this.screen.p[this.x2 + this.offset] = n;
                        this.screen.p[this.x2 + this.offset + 1] = n;
                        this.screen.p[this.x2 + this.offset + this.width] = n;
                        this.screen.p[this.x2 + this.offset + this.width + 1] = n;
                        this.zBuffer[this.x2 + this.offset] = this.z;
                    }
                }
                if (this.useIdBuffer) {
                    this.idBuffer[this.x2 + this.offset] = this.currentId;
                }
            }
            this.z += this.dz;
            this.x += this.dx;
            ++this.y;
        }
    }

    private void renderLinePT() {
        this.x = this.xL;
        while (this.x < this.xR) {
            this.pos = this.x + this.offset;
            if (this.z < this.zBuffer[this.pos]) {
                this.lutID = (this.nx >> 16 & 0xFF) + ((this.ny >> 16 & 0xFF) << 8);
                this.bkgrd = this.screen.p[this.pos];
                this.c = this.texture.pixel[(this.tx >> 16 & this.tw) + ((this.ty >> 16 & this.th) << this.tbitW)];
                this.c = idx3d_Color.multiply(this.c, this.diffuse[this.lutID]);
                this.s = this.specular[this.lutID];
                this.s = idx3d_Color.scale(this.s, this.reflectivity);
                this.c = idx3d_Color.transparency(this.bkgrd, this.c, this.transparency);
                this.c = idx3d_Color.add(this.c, this.s);
                this.screen.p[this.pos] = 0xFF000000 | this.c;
                this.zBuffer[this.pos] = this.z;
                if (this.useIdBuffer) {
                    this.idBuffer[this.pos] = this.currentId;
                }
            }
            this.z += this.dz;
            this.nx += this.dnx;
            this.ny += this.dny;
            this.tx += this.dtx;
            this.ty += this.dty;
            ++this.x;
        }
    }

    private void renderLineE() {
        this.x = this.xL;
        while (this.x < this.xR) {
            this.pos = this.x + this.offset;
            if (this.z < this.zBuffer[this.pos]) {
                this.lutID = (this.nx >> 16 & 0xFF) + ((this.ny >> 16 & 0xFF) << 8);
                this.bkgrd = this.screen.p[this.pos];
                this.s = idx3d_Color.add(this.specular[this.lutID], this.envmap[this.lutID]);
                this.s = idx3d_Color.scale(this.s, this.reflectivity);
                this.c = idx3d_Color.transparency(this.bkgrd, this.s, this.transparency);
                this.screen.p[this.pos] = 0xFF000000 | this.c;
                this.zBuffer[this.pos] = this.z;
                if (this.useIdBuffer) {
                    this.idBuffer[this.pos] = this.currentId;
                }
            }
            this.z += this.dz;
            this.nx += this.dnx;
            this.ny += this.dny;
            ++this.x;
        }
    }

    private void drawWireframe(idx3d_Triangle idx3d_Triangle2, int n) {
        this.drawLine(idx3d_Triangle2.p1, idx3d_Triangle2.p2, n);
        this.drawLine(idx3d_Triangle2.p2, idx3d_Triangle2.p3, n);
        this.drawLine(idx3d_Triangle2.p3, idx3d_Triangle2.p1, n);
    }

    private void renderLineF() {
        this.x = this.xL;
        while (this.x < this.xR) {
            this.pos = this.x + this.offset;
            if (this.z < this.zBuffer[this.pos]) {
                this.bkgrd = this.screen.p[this.pos];
                this.c = idx3d_Color.transparency(this.bkgrd, this.currentColor, this.transparency);
                this.screen.p[this.pos] = 0xFF000000 | this.c;
                this.zBuffer[this.pos] = this.z;
                if (this.useIdBuffer) {
                    this.idBuffer[this.pos] = this.currentId;
                }
            }
            this.z += this.dz;
            ++this.x;
        }
    }

    private void renderLine() {
        this.xL = this.xBase >> 16;
        this.xR = this.xMax >> 16;
        this.z = this.zBase;
        this.nx = this.nxBase;
        this.ny = this.nyBase;
        this.tx = this.txBase;
        this.ty = this.tyBase;
        if (this.xL < 0) {
            this.z -= this.xL * this.dz;
            this.nx -= this.xL * this.dnx;
            this.ny -= this.xL * this.dny;
            this.tx -= this.xL * this.dtx;
            this.ty -= this.xL * this.dty;
            this.xL = 0;
        }
        int n = this.xR = this.xR < this.width ? this.xR : this.width;
        if (this.mode == this.F) {
            this.renderLineF();
        } else if ((this.mode & this.SHADED) == this.P) {
            this.renderLineP();
        } else if ((this.mode & this.SHADED) == this.E) {
            this.renderLineE();
        } else if ((this.mode & this.SHADED) == this.T) {
            this.renderLineT();
        } else if ((this.mode & this.SHADED) == (this.P | this.E)) {
            this.renderLinePE();
        } else if ((this.mode & this.SHADED) == (this.P | this.T)) {
            this.renderLinePT();
        } else if ((this.mode & this.SHADED) == (this.P | this.E | this.T)) {
            this.renderLinePET();
        }
        this.offset += this.width;
        this.xBase += this.dxL;
        this.xMax += this.dxR;
        this.zBase += this.dzBase;
        this.nxBase += this.dnxBase;
        this.nyBase += this.dnyBase;
        this.txBase += this.dtxBase;
        this.tyBase += this.dtyBase;
    }

    public void render(idx3d_Triangle idx3d_Triangle2) {
        if (!this.ready) {
            return;
        }
        if (idx3d_Triangle2.parent == null) {
            return;
        }
        if ((this.mode & this.W) != 0) {
            this.drawWireframe(idx3d_Triangle2, this.color);
            if ((this.mode & this.W) == 0) {
                return;
            }
        }
        this.p1 = idx3d_Triangle2.p1;
        this.p2 = idx3d_Triangle2.p2;
        this.p3 = idx3d_Triangle2.p3;
        if (this.p1.y > this.p2.y) {
            this.tempVertex = this.p1;
            this.p1 = this.p2;
            this.p2 = this.tempVertex;
        }
        if (this.p2.y > this.p3.y) {
            this.tempVertex = this.p2;
            this.p2 = this.p3;
            this.p3 = this.tempVertex;
        }
        if (this.p1.y > this.p2.y) {
            this.tempVertex = this.p1;
            this.p1 = this.p2;
            this.p2 = this.tempVertex;
        }
        if (this.p1.y >= this.height) {
            return;
        }
        if (this.p3.y < 0) {
            return;
        }
        if (this.p1.y == this.p3.y) {
            return;
        }
        if (this.mode == this.F) {
            this.lutID = (int)(idx3d_Triangle2.n2.x * 127.0f + 127.0f) + ((int)(idx3d_Triangle2.n2.y * 127.0f + 127.0f) << 8);
            this.c = idx3d_Color.multiply(this.color, this.diffuse[this.lutID]);
            this.s = idx3d_Color.scale(this.specular[this.lutID], this.reflectivity);
            this.currentColor = idx3d_Color.add(this.c, this.s);
        }
        this.currentId = idx3d_Triangle2.parent.id << 16 | idx3d_Triangle2.id;
        this.x1 = this.p1.x << 8;
        this.x2 = this.p2.x << 8;
        this.x3 = this.p3.x << 8;
        this.y1 = this.p1.y;
        this.y2 = this.p2.y;
        this.y3 = this.p3.y;
        this.x4 = this.x1 + (this.x3 - this.x1) * (this.y2 - this.y1) / (this.y3 - this.y1);
        this.x1 <<= 8;
        this.x2 <<= 8;
        this.x3 <<= 8;
        this.x4 <<= 8;
        this.z1 = this.p1.z;
        this.z2 = this.p2.z;
        this.z3 = this.p3.z;
        this.nx1 = this.p1.nx << 16;
        this.nx2 = this.p2.nx << 16;
        this.nx3 = this.p3.nx << 16;
        this.ny1 = this.p1.ny << 16;
        this.ny2 = this.p2.ny << 16;
        this.ny3 = this.p3.ny << 16;
        this.tx1 = this.p1.tx << 16;
        this.tx2 = this.p2.tx << 16;
        this.tx3 = this.p3.tx << 16;
        this.ty1 = this.p1.ty << 16;
        this.ty2 = this.p2.ty << 16;
        this.ty3 = this.p3.ty << 16;
        this.dx = this.x4 - this.x2 >> 16;
        if (this.dx == 0) {
            return;
        }
        this.temp = 256 * (this.y2 - this.y1) / (this.y3 - this.y1);
        this.z4 = this.z1 + (this.z3 - this.z1 >> 8) * this.temp;
        this.nx4 = this.nx1 + (this.nx3 - this.nx1 >> 8) * this.temp;
        this.ny4 = this.ny1 + (this.ny3 - this.ny1 >> 8) * this.temp;
        this.tx4 = this.tx1 + (this.tx3 - this.tx1 >> 8) * this.temp;
        this.ty4 = this.ty1 + (this.ty3 - this.ty1 >> 8) * this.temp;
        this.dz = (this.z4 - this.z2) / this.dx;
        this.dnx = (this.nx4 - this.nx2) / this.dx;
        this.dny = (this.ny4 - this.ny2) / this.dx;
        this.dtx = (this.tx4 - this.tx2) / this.dx;
        this.dty = (this.ty4 - this.ty2) / this.dx;
        if (this.dx < 0) {
            this.temp = this.x2;
            this.x2 = this.x4;
            this.x4 = this.temp;
            this.z2 = this.z4;
            this.tx2 = this.tx4;
            this.ty2 = this.ty4;
            this.nx2 = this.nx4;
            this.ny2 = this.ny4;
        }
        if (this.y2 >= 0) {
            this.dy = this.y2 - this.y1;
            if (this.dy != 0) {
                this.dxL = (this.x2 - this.x1) / this.dy;
                this.dxR = (this.x4 - this.x1) / this.dy;
                this.dzBase = (this.z2 - this.z1) / this.dy;
                this.dnxBase = (this.nx2 - this.nx1) / this.dy;
                this.dnyBase = (this.ny2 - this.ny1) / this.dy;
                this.dtxBase = (this.tx2 - this.tx1) / this.dy;
                this.dtyBase = (this.ty2 - this.ty1) / this.dy;
            }
            this.xBase = this.x1;
            this.xMax = this.x1;
            this.zBase = this.z1;
            this.nxBase = this.nx1;
            this.nyBase = this.ny1;
            this.txBase = this.tx1;
            this.tyBase = this.ty1;
            if (this.y1 < 0) {
                this.xBase -= this.y1 * this.dxL;
                this.xMax -= this.y1 * this.dxR;
                this.zBase -= this.y1 * this.dzBase;
                this.nxBase -= this.y1 * this.dnxBase;
                this.nyBase -= this.y1 * this.dnyBase;
                this.txBase -= this.y1 * this.dtxBase;
                this.tyBase -= this.y1 * this.dtyBase;
                this.y1 = 0;
            }
            this.y2 = this.y2 < this.height ? this.y2 : this.height;
            this.offset = this.y1 * this.width;
            this.y = this.y1;
            while (this.y < this.y2) {
                this.renderLine();
                ++this.y;
            }
        }
        if (this.y2 < this.height) {
            this.dy = this.y3 - this.y2;
            if (this.dy != 0) {
                this.dxL = (this.x3 - this.x2) / this.dy;
                this.dxR = (this.x3 - this.x4) / this.dy;
                this.dzBase = (this.z3 - this.z2) / this.dy;
                this.dnxBase = (this.nx3 - this.nx2) / this.dy;
                this.dnyBase = (this.ny3 - this.ny2) / this.dy;
                this.dtxBase = (this.tx3 - this.tx2) / this.dy;
                this.dtyBase = (this.ty3 - this.ty2) / this.dy;
            }
            this.xBase = this.x2;
            this.xMax = this.x4;
            this.zBase = this.z2;
            this.nxBase = this.nx2;
            this.nyBase = this.ny2;
            this.txBase = this.tx2;
            this.tyBase = this.ty2;
            if (this.y2 < 0) {
                this.xBase -= this.y2 * this.dxL;
                this.xMax -= this.y2 * this.dxR;
                this.zBase -= this.y2 * this.dzBase;
                this.nxBase -= this.y2 * this.dnxBase;
                this.nyBase -= this.y2 * this.dnyBase;
                this.txBase -= this.y2 * this.dtxBase;
                this.tyBase -= this.y2 * this.dtyBase;
                this.y2 = 0;
            }
            this.y3 = this.y3 < this.height ? this.y3 : this.height;
            this.offset = this.y2 * this.width;
            this.y = this.y2;
            while (this.y < this.y3) {
                this.renderLine();
                ++this.y;
            }
        }
    }

    private void renderLineT() {
        this.x = this.xL;
        while (this.x < this.xR) {
            this.pos = this.x + this.offset;
            if (this.z < this.zBuffer[this.pos]) {
                this.bkgrd = this.screen.p[this.pos];
                this.c = this.texture.pixel[(this.tx >> 16 & this.tw) + ((this.ty >> 16 & this.th) << this.tbitW)];
                this.c = idx3d_Color.transparency(this.bkgrd, this.c, this.transparency);
                this.screen.p[this.pos] = 0xFF000000 | this.c;
                this.zBuffer[this.pos] = this.z;
                if (this.useIdBuffer) {
                    this.idBuffer[this.pos] = this.currentId;
                }
            }
            this.z += this.dz;
            this.tx += this.dtx;
            this.ty += this.dty;
            ++this.x;
        }
    }

    public idx3d_Rasterizer(idx3d_RenderPipeline idx3d_RenderPipeline2) {
        this.rebuildReferences(idx3d_RenderPipeline2);
        this.loadLightmap(idx3d_RenderPipeline2.lightmap);
    }

    void rebuildReferences(idx3d_RenderPipeline idx3d_RenderPipeline2) {
        this.screen = idx3d_RenderPipeline2.screen;
        this.zBuffer = idx3d_RenderPipeline2.zBuffer;
        this.idBuffer = idx3d_RenderPipeline2.idBuffer;
        this.width = this.screen.w;
        this.height = this.screen.h;
        this.useIdBuffer = idx3d_RenderPipeline2.useIdBuffer;
    }

    private void renderLinePE() {
        this.x = this.xL;
        while (this.x < this.xR) {
            this.pos = this.x + this.offset;
            if (this.z < this.zBuffer[this.pos]) {
                this.lutID = (this.nx >> 16 & 0xFF) + ((this.ny >> 16 & 0xFF) << 8);
                this.bkgrd = this.screen.p[this.pos];
                this.c = idx3d_Color.multiply(this.color, this.diffuse[this.lutID]);
                this.s = idx3d_Color.add(this.specular[this.lutID], this.envmap[this.lutID]);
                this.s = idx3d_Color.scale(this.s, this.reflectivity);
                this.c = idx3d_Color.transparency(this.bkgrd, this.c, this.transparency);
                this.c = idx3d_Color.add(this.c, this.s);
                this.screen.p[this.pos] = 0xFF000000 | this.c;
                this.zBuffer[this.pos] = this.z;
                if (this.useIdBuffer) {
                    this.idBuffer[this.pos] = this.currentId;
                }
            }
            this.z += this.dz;
            this.nx += this.dnx;
            this.ny += this.dny;
            ++this.x;
        }
    }

    public void loadMaterial(idx3d_Material idx3d_Material2) {
        this.color = idx3d_Material2.color;
        this.transparency = idx3d_Material2.transparency;
        this.reflectivity = idx3d_Material2.reflectivity;
        this.texture = idx3d_Material2.texture;
        this.envmap = (int[])(idx3d_Material2.envmap != null ? idx3d_Material2.envmap.pixel : null);
        if (this.texture != null) {
            this.tw = this.texture.width - 1;
            this.th = this.texture.height - 1;
            this.tbitW = this.texture.bitWidth;
            this.tbitH = this.texture.bitHeight;
        }
        this.mode = 0;
        if (!idx3d_Material2.flat) {
            this.mode |= this.P;
        }
        if (this.envmap != null) {
            this.mode |= this.E;
        }
        if (this.texture != null) {
            this.mode |= this.T;
        }
        if (idx3d_Material2.wireframe) {
            this.mode |= this.W;
        }
        this.materialLoaded = true;
        this.ready = this.lightmapLoaded && this.materialLoaded;
    }

    private void renderLineP() {
        this.x = this.xL;
        while (this.x < this.xR) {
            this.pos = this.x + this.offset;
            if (this.z < this.zBuffer[this.pos]) {
                this.lutID = (this.nx >> 16 & 0xFF) + ((this.ny >> 16 & 0xFF) << 8);
                this.bkgrd = this.screen.p[this.pos];
                this.c = idx3d_Color.multiply(this.color, this.diffuse[this.lutID]);
                this.s = this.specular[this.lutID];
                this.s = idx3d_Color.scale(this.s, this.reflectivity);
                this.c = idx3d_Color.transparency(this.bkgrd, this.c, this.transparency);
                this.c = idx3d_Color.add(this.c, this.s);
                this.screen.p[this.pos] = 0xFF000000 | this.c;
                this.zBuffer[this.pos] = this.z;
                if (this.useIdBuffer) {
                    this.idBuffer[this.pos] = this.currentId;
                }
            }
            this.z += this.dz;
            this.nx += this.dnx;
            this.ny += this.dny;
            ++this.x;
        }
    }
}

