/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.EventQueue;
import org.lwjgl.opengl.MacOSXDisplay;

final class MouseEventQueue
extends EventQueue
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final int WHEEL_SCALE = 120;
    public static final int NUM_BUTTONS = 3;
    private static final int EVENT_SIZE = 5;
    private final int width;
    private final int height;
    private boolean grabbed;
    private final IntBuffer delta_buffer = BufferUtils.createIntBuffer(2);
    private int accum_dx;
    private int accum_dy;
    private int accum_dz;
    private int last_x;
    private int last_y;
    private final int[] event = new int[5];
    private final byte[] buttons = new byte[3];

    MouseEventQueue(int width, int height) {
        super(5);
        this.width = width;
        this.height = height;
        this.resetCursorToCenter();
    }

    public synchronized void setGrabbed(boolean grabbed) {
        this.grabbed = grabbed;
        this.resetCursorToCenter();
    }

    public synchronized boolean isGrabbed() {
        return this.grabbed;
    }

    private int transformY(int y) {
        return this.height - 1 - y;
    }

    private void resetCursorToCenter() {
        this.clearEvents();
        this.accum_dy = 0;
        this.accum_dx = 0;
        ((MacOSXDisplay)Display.getImplementation()).getMouseDeltas(this.delta_buffer);
    }

    private boolean putMouseEvent(int button, int state, int dz) {
        if (this.grabbed) {
            return this.putMouseEventWithCoords(button, state, 0, 0, dz);
        }
        return this.putMouseEventWithCoords(button, state, this.last_x, this.last_y, dz);
    }

    private boolean putMouseEventWithCoords(int button, int state, int coord1, int coord2, int dz) {
        this.event[0] = button;
        this.event[1] = state;
        this.event[2] = coord1;
        this.event[3] = coord2;
        this.event[4] = dz;
        return this.putEvent(this.event);
    }

    public synchronized void poll(IntBuffer coord_buffer, ByteBuffer buttons_buffer) {
        if (this.grabbed) {
            coord_buffer.put(0, this.accum_dx);
            coord_buffer.put(1, this.accum_dy);
        } else {
            coord_buffer.put(0, this.last_x);
            coord_buffer.put(1, this.last_y);
        }
        coord_buffer.put(2, this.accum_dz);
        this.accum_dz = 0;
        this.accum_dy = 0;
        this.accum_dx = 0;
        int old_position = buttons_buffer.position();
        buttons_buffer.put(this.buttons, 0, this.buttons.length);
        buttons_buffer.position(old_position);
    }

    private synchronized void setCursorPos(int x, int y) {
        y = this.transformY(y);
        if (this.grabbed) {
            return;
        }
        int dx = x - this.last_x;
        int dy = y - this.last_y;
        this.accum_dx += dx;
        this.accum_dy += dy;
        this.last_x = x;
        this.last_y = y;
        this.putMouseEventWithCoords(-1, 0, x, y, 0);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    private void handleButton(MouseEvent e) {
        byte state;
        byte button;
        switch (e.getButton()) {
            case 1: {
                if (!e.isControlDown()) {
                    button = 0;
                    break;
                }
                button = 1;
                break;
            }
            case 2: {
                button = 2;
                break;
            }
            case 3: {
                button = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a valid button: " + e.getButton());
            }
        }
        switch (e.getID()) {
            case 501: {
                state = 1;
                break;
            }
            case 502: {
                state = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a valid event ID: " + e.getID());
            }
        }
        this.setButton(button, state);
    }

    public void mousePressed(MouseEvent e) {
        this.handleButton(e);
    }

    private synchronized void setButton(byte button, byte state) {
        this.buttons[button] = state;
        this.putMouseEvent(button, state, 0);
    }

    public void mouseReleased(MouseEvent e) {
        this.handleButton(e);
    }

    private void handleMotion(MouseEvent e) {
        if (this.grabbed) {
            this.updateDeltas();
        } else {
            this.setCursorPos(e.getX(), e.getY());
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.handleMotion(e);
    }

    public void mouseMoved(MouseEvent e) {
        this.handleMotion(e);
    }

    private synchronized void handleWheel(int amount) {
        this.accum_dz += amount;
        this.putMouseEvent(-1, 0, amount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDeltas() {
        if (!this.grabbed) {
            return;
        }
        MouseEventQueue mouseEventQueue = this;
        synchronized (mouseEventQueue) {
            ((MacOSXDisplay)Display.getImplementation()).getMouseDeltas(this.delta_buffer);
            int dx = this.delta_buffer.get(0);
            int dy = -this.delta_buffer.get(1);
            if (dx != 0 || dy != 0) {
                this.putMouseEventWithCoords(-1, 0, dx, dy, 0);
                this.accum_dx += dx;
                this.accum_dy += dy;
            }
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        int wheel_amount = -e.getWheelRotation() * 120;
        this.handleWheel(wheel_amount);
    }
}

