/*
 * Decompiled with CFR 0.152.
 */
package org.jouvieje.Fmod.Misc;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.jouvieje.Fmod.Misc.BufferUtils;
import org.jouvieje.Fmod.Misc.SizeOfPrimitive;

public class FileWriterUtils
implements SizeOfPrimitive {
    private static ByteBuffer shortBuffer = BufferUtils.newByteBuffer(2);
    private static ByteBuffer charBuffer = BufferUtils.newByteBuffer(2);
    private static ByteBuffer intBuffer = BufferUtils.newByteBuffer(4);
    private static ByteBuffer longBuffer = BufferUtils.newByteBuffer(8);
    private static ByteBuffer floatBuffer = BufferUtils.newByteBuffer(4);
    private static ByteBuffer doubleBuffer = BufferUtils.newByteBuffer(8);

    public static void writeByte(RandomAccessFile randomAccessFile, byte by) throws IOException {
        randomAccessFile.writeByte(by);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeShort(RandomAccessFile randomAccessFile, short s) throws IOException {
        ByteBuffer byteBuffer = shortBuffer;
        synchronized (byteBuffer) {
            shortBuffer.putShort(0, s);
            randomAccessFile.getChannel().write(shortBuffer);
            shortBuffer.rewind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeChar(RandomAccessFile randomAccessFile, char c) throws IOException {
        ByteBuffer byteBuffer = charBuffer;
        synchronized (byteBuffer) {
            charBuffer.putChar(0, c);
            randomAccessFile.getChannel().write(charBuffer);
            charBuffer.rewind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeInt(RandomAccessFile randomAccessFile, int n) throws IOException {
        ByteBuffer byteBuffer = intBuffer;
        synchronized (byteBuffer) {
            intBuffer.putInt(0, n);
            randomAccessFile.getChannel().write(intBuffer);
            intBuffer.rewind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFloat(RandomAccessFile randomAccessFile, float f) throws IOException {
        ByteBuffer byteBuffer = floatBuffer;
        synchronized (byteBuffer) {
            floatBuffer.putFloat(0, f);
            randomAccessFile.getChannel().write(floatBuffer);
            floatBuffer.rewind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLong(RandomAccessFile randomAccessFile, long l) throws IOException {
        ByteBuffer byteBuffer = longBuffer;
        synchronized (byteBuffer) {
            longBuffer.putLong(0, l);
            randomAccessFile.getChannel().write(longBuffer);
            longBuffer.rewind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDouble(RandomAccessFile randomAccessFile, double d) throws IOException {
        ByteBuffer byteBuffer = doubleBuffer;
        synchronized (byteBuffer) {
            doubleBuffer.putDouble(0, d);
            randomAccessFile.getChannel().write(doubleBuffer);
            doubleBuffer.rewind();
        }
    }

    public static void writeByteArray(RandomAccessFile randomAccessFile, byte[] byArray) throws IOException {
        FileWriterUtils.writeByteArray(randomAccessFile, byArray, 0, byArray.length);
    }

    public static void writeByteArray(RandomAccessFile randomAccessFile, byte[] byArray, int n, int n2) throws IOException {
        randomAccessFile.write(byArray, n, n2);
    }

    public static int writeByteBuffer(RandomAccessFile randomAccessFile, ByteBuffer byteBuffer) throws IOException {
        return randomAccessFile.getChannel().write(byteBuffer);
    }

    public static int writeByteBuffer(RandomAccessFile randomAccessFile, ByteBuffer byteBuffer, int n) throws IOException {
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        byteBuffer2.limit(byteBuffer2.position() + n);
        int n2 = randomAccessFile.getChannel().write(byteBuffer2);
        byteBuffer.position(byteBuffer2.position());
        return n2;
    }
}

