/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.newdawn.slick.util.Log;

public class ResourceLoader {
    public static InputStream getResourceAsStream(String ref) {
        String cpRef = ref.replace('\\', '/');
        InputStream in = ResourceLoader.class.getClassLoader().getResourceAsStream(cpRef);
        if (in == null) {
            File file = new File(ref);
            try {
                if (System.getProperty("jnlp.slick.webstart", "false").equals("false")) {
                    in = new FileInputStream(file);
                    return new BufferedInputStream(in);
                }
                Log.error("Resource not found: " + ref);
                throw new RuntimeException("Resource not found: " + ref);
            }
            catch (IOException e) {
                Log.error("Resource not found: " + ref);
                throw new RuntimeException("Resource not found: " + ref);
            }
        }
        return new BufferedInputStream(in);
    }

    public static URL getResource(String ref) {
        String cpRef = ref.replace('\\', '/');
        URL url = ResourceLoader.class.getClassLoader().getResource(cpRef);
        if (url == null) {
            File file = new File(ref);
            try {
                if (System.getProperty("jnlp.slick.webstart", "false").equals("false")) {
                    return file.toURL();
                }
                Log.error("Resource not found: " + ref);
                throw new RuntimeException("Resource not found: " + ref);
            }
            catch (IOException e) {
                Log.error("Resource not found: " + ref);
                throw new RuntimeException("Resource not found: " + ref);
            }
        }
        return url;
    }
}

