/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.svg;

import com.tinyline.svg.AnimationCallback;
import com.tinyline.svg.ImageLoader;
import com.tinyline.svg.SVG;
import com.tinyline.svg.SVGAttr;
import com.tinyline.svg.SVGDocument;
import com.tinyline.svg.SVGFontElem;
import com.tinyline.svg.SVGImageElem;
import com.tinyline.svg.SVGImageProducer;
import com.tinyline.svg.SVGParser;
import com.tinyline.svg.SVGRaster;
import com.tinyline.tiny2d.TinyBitmap;
import com.tinyline.tiny2d.TinyPixbuf;
import com.tinyline.tiny2d.TinyRect;
import com.tinyline.tiny2d.TinyString;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.zip.GZIPInputStream;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.AppGameContainer;
import org.newdawn.slick.BasicGame;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.util.ResourceLoader;

public class SVGTest
extends BasicGame
implements SVGImageProducer,
ImageLoader {
    private int texture;
    private TinyPixbuf pixBuffer;
    private SVGRaster raster;
    private ByteBuffer textureBuffer;
    private SVGDocument doc;
    private int time = 0;
    private int width = 256;
    private int height = 256;

    public SVGTest() {
        super("SVGTest");
    }

    protected IntBuffer createIntBuffer(int size) {
        ByteBuffer temp = ByteBuffer.allocateDirect(4 * size);
        temp.order(ByteOrder.nativeOrder());
        return temp.asIntBuffer();
    }

    private int createTextureID() {
        IntBuffer tmp = this.createIntBuffer(1);
        GL11.glGenTextures((IntBuffer)tmp);
        return tmp.get(0);
    }

    private int createTexture(int width, int height) {
        int target = 3553;
        int textureID = this.createTextureID();
        GL11.glBindTexture((int)target, (int)textureID);
        byte[] data = new byte[4 * width * height];
        this.textureBuffer = ByteBuffer.allocateDirect(data.length);
        this.textureBuffer.order(ByteOrder.nativeOrder());
        this.textureBuffer.put(data, 0, data.length);
        this.textureBuffer.flip();
        GL11.glTexParameteri((int)target, (int)10241, (int)9729);
        GL11.glTexParameteri((int)target, (int)10240, (int)9729);
        GL11.glTexImage2D((int)target, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, (ByteBuffer)this.textureBuffer);
        return textureID;
    }

    public SVGDocument loadSVG(String ref) {
        try {
            InputStream is = ResourceLoader.getResourceAsStream(ref);
            if (ref.endsWith("svgz")) {
                is = new GZIPInputStream(is);
            }
            final SVGDocument doc = this.raster.createSVGDocument();
            TinyPixbuf pixbuf = this.raster.getPixelBuffer();
            SVGAttr attrParser = new SVGAttr(pixbuf.width, pixbuf.height);
            SVGParser parser = new SVGParser(attrParser);
            parser.load(doc, is);
            doc.nActiveAnimations = 0;
            doc.animTargets.count = 0;
            doc.addAnimations(doc.root);
            doc.acb = new AnimationCallback(){

                public void postSMILEvent(int eventType, TinyString event) {
                    System.out.println(eventType + ":" + event);
                    doc.resolveEventBased(event);
                }
            };
            return doc;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void init(GameContainer container) throws SlickException {
        SVGFontElem font;
        this.texture = this.createTexture(this.width, this.height);
        TinyPixbuf buffer = new TinyPixbuf(this.width, this.height);
        this.raster = new SVGRaster(buffer);
        this.raster.setSVGImageProducer((SVGImageProducer)this);
        SVGImageElem.setImageLoader((ImageLoader)this);
        SVGDocument fontDoc = this.loadSVG("org/newdawn/slick/data/helvetica_svg");
        SVGDocument.defaultFont = font = SVGDocument.getFont((SVGDocument)fontDoc, (TinyString)SVG.VAL_DEFAULT_FONTFAMILY);
        this.doc = this.loadSVG("testdata/retro4.svgz");
        this.raster.setAntialiased(true);
        this.raster.setSVGDocument(this.doc);
        this.raster.setCamera();
        this.raster.update();
        this.raster.sendPixels();
    }

    public void update(GameContainer container, int delta) throws SlickException {
        this.time += delta;
        TinyRect dirty = this.doc.animate(this.time / 4);
        this.raster.setDevClip(dirty);
        this.raster.update();
        this.raster.sendPixels();
        Thread.yield();
    }

    public void render(GameContainer container, Graphics g) throws SlickException {
        GL11.glEnable((int)3553);
        GL11.glBindTexture((int)3553, (int)this.texture);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)10.0f, (float)50.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2f((float)10.0f, (float)562.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2f((float)522.0f, (float)562.0f);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2f((float)522.0f, (float)50.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)530.0f, (float)50.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2f((float)530.0f, (float)306.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2f((float)786.0f, (float)306.0f);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2f((float)786.0f, (float)50.0f);
        GL11.glEnd();
        Texture.unbind();
    }

    public static void main(String[] argv) {
        try {
            AppGameContainer container = new AppGameContainer(new SVGTest(), 800, 600, false);
            container.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean hasConsumer() {
        return true;
    }

    public void imageComplete() {
        TinyRect dirty = this.raster.getDevClip();
        int width = dirty.xmax - dirty.xmin;
        int height = dirty.ymax - dirty.ymin;
        GL11.glBindTexture((int)3553, (int)this.texture);
        int[] data = this.raster.getPixelBuffer().pixels32;
        this.textureBuffer.clear();
        for (int y = dirty.ymin; y < dirty.ymax; ++y) {
            for (int x = dirty.xmin; x < dirty.xmax; ++x) {
                int i = x + y * this.width;
                int red = (data[i] & 0xFF0000) >> 16 & 0xFF;
                int green = (data[i] & 0xFF00) >> 8 & 0xFF;
                int blue = data[i] & 0xFF;
                int alpha = (data[i] & 0xFF000000) >> 24 & 0xFF;
                this.textureBuffer.put((byte)red);
                this.textureBuffer.put((byte)green);
                this.textureBuffer.put((byte)blue);
                this.textureBuffer.put((byte)alpha);
            }
        }
        this.textureBuffer.flip();
        GL11.glTexSubImage2D((int)3553, (int)0, (int)dirty.xmin, (int)dirty.ymin, (int)width, (int)height, (int)6408, (int)5121, (ByteBuffer)this.textureBuffer);
        Texture.unbind();
    }

    public void sendPixels() {
    }

    public TinyBitmap createTinyBitmap(TinyString arg0) {
        return null;
    }

    public TinyBitmap createTinyBitmap(byte[] arg0, int arg1, int arg2) {
        return null;
    }
}

