/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.opengl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.newdawn.slick.opengl.LoadableImageData;

public class ImageIOImageData
implements LoadableImageData {
    private static final ColorModel glAlphaColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, false, 3, 0);
    private static final ColorModel glColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 0}, false, false, 1, 0);
    private int depth;
    private int height;
    private int width;
    private int texWidth;
    private int texHeight;

    public int getDepth() {
        return this.depth;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTexHeight() {
        return this.texHeight;
    }

    public int getTexWidth() {
        return this.texWidth;
    }

    public int getWidth() {
        return this.width;
    }

    public ByteBuffer loadImage(InputStream fis) throws IOException {
        return this.loadImage(fis, true, null);
    }

    public ByteBuffer loadImage(InputStream fis, boolean flipped, int[] transparent) throws IOException {
        return this.loadImage(fis, flipped, false, transparent);
    }

    public ByteBuffer loadImage(InputStream fis, boolean flipped, boolean forceAlpha, int[] transparent) throws IOException {
        BufferedImage texImage;
        WritableRaster raster;
        int texWidth;
        if (transparent != null) {
            forceAlpha = true;
        }
        BufferedImage bufferedImage = ImageIO.read(fis);
        ByteBuffer imageBuffer = null;
        int texHeight = 2;
        for (texWidth = 2; texWidth < bufferedImage.getWidth(); texWidth *= 2) {
        }
        while (texHeight < bufferedImage.getHeight()) {
            texHeight *= 2;
        }
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        this.texHeight = texHeight;
        this.texWidth = texWidth;
        if (bufferedImage.getColorModel().hasAlpha() || forceAlpha) {
            this.depth = 32;
            raster = Raster.createInterleavedRaster(0, texWidth, texHeight, 4, null);
            texImage = new BufferedImage(glAlphaColorModel, raster, false, new Hashtable());
        } else {
            this.depth = 24;
            raster = Raster.createInterleavedRaster(0, texWidth, texHeight, 3, null);
            texImage = new BufferedImage(glColorModel, raster, false, new Hashtable());
        }
        Graphics2D g = (Graphics2D)texImage.getGraphics();
        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        g.fillRect(0, 0, texWidth, texHeight);
        if (!flipped) {
            g.scale(1.0, -1.0);
            g.drawImage((Image)bufferedImage, 0, -this.height, null);
        } else {
            g.drawImage((Image)bufferedImage, 0, 0, null);
        }
        byte[] data = ((DataBufferByte)texImage.getRaster().getDataBuffer()).getData();
        if (transparent != null) {
            for (int i = 0; i < data.length; i += 4) {
                boolean match = true;
                for (int c = 0; c < 3; ++c) {
                    int value;
                    int n = value = data[i + c] < 0 ? 256 + data[i + c] : data[i + c];
                    if (value == transparent[c]) continue;
                    match = false;
                }
                if (!match) continue;
                data[i + 3] = 0;
            }
        }
        imageBuffer = ByteBuffer.allocateDirect(data.length);
        imageBuffer.order(ByteOrder.nativeOrder());
        imageBuffer.put(data, 0, data.length);
        imageBuffer.flip();
        return imageBuffer;
    }

    public ByteBuffer getImageBufferData() {
        throw new RuntimeException("ImageIOImageData doesn't store it's image.");
    }
}

