/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.openal;

import org.newdawn.slick.openal.SoundStore;

public class InternalSound {
    private SoundStore store;
    private int buffer;
    private int index = -1;

    InternalSound(SoundStore store, int buffer) {
        this.store = store;
        this.buffer = buffer;
    }

    protected InternalSound() {
    }

    public void stop() {
        if (this.index != -1) {
            this.store.stopSource(this.index);
        }
    }

    public boolean isPlaying() {
        if (this.index != -1) {
            return this.store.isPlaying(this.index);
        }
        return false;
    }

    public void playAsSoundEffect(float pitch, float gain, boolean loop) {
        this.index = this.store.playAsSound(this.buffer, pitch, gain, loop);
    }

    public void playAsSoundEffect(float pitch, float gain, boolean loop, float x, float y, float z) {
        this.index = this.store.playAsSoundAt(this.buffer, pitch, gain, loop, x, y, z);
    }

    public void playAsMusic(float pitch, float gain, boolean loop) {
        this.store.playAsMusic(this.buffer, pitch, gain, loop);
    }

    public static void pauseMusic() {
        SoundStore.get().pauseLoop();
    }

    public static void restartMusic() {
        SoundStore.get().restartLoop();
    }
}

