/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.geom;

import org.newdawn.slick.geom.Circle;

public class Rectangle {
    public float width;
    public float height;
    public float x;
    public float y;

    public Rectangle(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public boolean contains(float xp, float yp) {
        return xp >= this.x && yp >= this.y && xp <= this.x + this.width && yp <= this.y + this.height;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public boolean intersects(Rectangle other) {
        if (this.x > other.x + other.width || this.x + this.width < other.x) {
            return false;
        }
        return !(this.y > other.y + other.height) && !(this.y + this.height < other.y);
    }

    public boolean intersects(Circle other) {
        return other.intersects(this);
    }

    public String toString() {
        return "[Rectangle " + this.width + "x" + this.height + "]";
    }
}

