/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Controller;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.newdawn.slick.InputListener;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.util.Log;

public class Input {
    public static final int ANY_CONTROLLER = -1;
    public static final int KEY_ESCAPE = 1;
    public static final int KEY_1 = 2;
    public static final int KEY_2 = 3;
    public static final int KEY_3 = 4;
    public static final int KEY_4 = 5;
    public static final int KEY_5 = 6;
    public static final int KEY_6 = 7;
    public static final int KEY_7 = 8;
    public static final int KEY_8 = 9;
    public static final int KEY_9 = 10;
    public static final int KEY_0 = 11;
    public static final int KEY_MINUS = 12;
    public static final int KEY_EQUALS = 13;
    public static final int KEY_BACK = 14;
    public static final int KEY_TAB = 15;
    public static final int KEY_Q = 16;
    public static final int KEY_W = 17;
    public static final int KEY_E = 18;
    public static final int KEY_R = 19;
    public static final int KEY_T = 20;
    public static final int KEY_Y = 21;
    public static final int KEY_U = 22;
    public static final int KEY_I = 23;
    public static final int KEY_O = 24;
    public static final int KEY_P = 25;
    public static final int KEY_LBRACKET = 26;
    public static final int KEY_RBRACKET = 27;
    public static final int KEY_RETURN = 28;
    public static final int KEY_ENTER = 28;
    public static final int KEY_LCONTROL = 29;
    public static final int KEY_A = 30;
    public static final int KEY_S = 31;
    public static final int KEY_D = 32;
    public static final int KEY_F = 33;
    public static final int KEY_G = 34;
    public static final int KEY_H = 35;
    public static final int KEY_J = 36;
    public static final int KEY_K = 37;
    public static final int KEY_L = 38;
    public static final int KEY_SEMICOLON = 39;
    public static final int KEY_APOSTROPHE = 40;
    public static final int KEY_GRAVE = 41;
    public static final int KEY_LSHIFT = 42;
    public static final int KEY_BACKSLASH = 43;
    public static final int KEY_Z = 44;
    public static final int KEY_X = 45;
    public static final int KEY_C = 46;
    public static final int KEY_V = 47;
    public static final int KEY_B = 48;
    public static final int KEY_N = 49;
    public static final int KEY_M = 50;
    public static final int KEY_COMMA = 51;
    public static final int KEY_PERIOD = 52;
    public static final int KEY_SLASH = 53;
    public static final int KEY_RSHIFT = 54;
    public static final int KEY_MULTIPLY = 55;
    public static final int KEY_LMENU = 56;
    public static final int KEY_SPACE = 57;
    public static final int KEY_CAPITAL = 58;
    public static final int KEY_F1 = 59;
    public static final int KEY_F2 = 60;
    public static final int KEY_F3 = 61;
    public static final int KEY_F4 = 62;
    public static final int KEY_F5 = 63;
    public static final int KEY_F6 = 64;
    public static final int KEY_F7 = 65;
    public static final int KEY_F8 = 66;
    public static final int KEY_F9 = 67;
    public static final int KEY_F10 = 68;
    public static final int KEY_NUMLOCK = 69;
    public static final int KEY_SCROLL = 70;
    public static final int KEY_NUMPAD7 = 71;
    public static final int KEY_NUMPAD8 = 72;
    public static final int KEY_NUMPAD9 = 73;
    public static final int KEY_SUBTRACT = 74;
    public static final int KEY_NUMPAD4 = 75;
    public static final int KEY_NUMPAD5 = 76;
    public static final int KEY_NUMPAD6 = 77;
    public static final int KEY_ADD = 78;
    public static final int KEY_NUMPAD1 = 79;
    public static final int KEY_NUMPAD2 = 80;
    public static final int KEY_NUMPAD3 = 81;
    public static final int KEY_NUMPAD0 = 82;
    public static final int KEY_DECIMAL = 83;
    public static final int KEY_F11 = 87;
    public static final int KEY_F12 = 88;
    public static final int KEY_F13 = 100;
    public static final int KEY_F14 = 101;
    public static final int KEY_F15 = 102;
    public static final int KEY_KANA = 112;
    public static final int KEY_CONVERT = 121;
    public static final int KEY_NOCONVERT = 123;
    public static final int KEY_YEN = 125;
    public static final int KEY_NUMPADEQUALS = 141;
    public static final int KEY_CIRCUMFLEX = 144;
    public static final int KEY_AT = 145;
    public static final int KEY_COLON = 146;
    public static final int KEY_UNDERLINE = 147;
    public static final int KEY_KANJI = 148;
    public static final int KEY_STOP = 149;
    public static final int KEY_AX = 150;
    public static final int KEY_UNLABELED = 151;
    public static final int KEY_NUMPADENTER = 156;
    public static final int KEY_RCONTROL = 157;
    public static final int KEY_NUMPADCOMMA = 179;
    public static final int KEY_DIVIDE = 181;
    public static final int KEY_SYSRQ = 183;
    public static final int KEY_RMENU = 184;
    public static final int KEY_PAUSE = 197;
    public static final int KEY_HOME = 199;
    public static final int KEY_UP = 200;
    public static final int KEY_PRIOR = 201;
    public static final int KEY_LEFT = 203;
    public static final int KEY_RIGHT = 205;
    public static final int KEY_END = 207;
    public static final int KEY_DOWN = 208;
    public static final int KEY_NEXT = 209;
    public static final int KEY_INSERT = 210;
    public static final int KEY_DELETE = 211;
    public static final int KEY_LWIN = 219;
    public static final int KEY_RWIN = 220;
    public static final int KEY_APPS = 221;
    public static final int KEY_POWER = 222;
    public static final int KEY_SLEEP = 223;
    private static final int LEFT = 0;
    private static final int RIGHT = 1;
    private static final int UP = 2;
    private static final int DOWN = 3;
    private static final int BUTTON1 = 4;
    private static final int BUTTON2 = 5;
    private static final int BUTTON3 = 6;
    private static boolean controllersInited = false;
    private static ArrayList controllers = new ArrayList();
    private int lastMouseX;
    private int lastMouseY;
    private char[] keys = new char[1024];
    private boolean[][] controls = new boolean[10][8];
    private boolean consumed = false;
    private ArrayList listeners = new ArrayList();
    private int wheel;
    private int height;
    private boolean displayActive = true;

    public Input(int height) {
        this.init(height);
    }

    public void addListener(InputListener listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public void addPrimaryListener(InputListener listener) {
        this.listeners.add(0, listener);
    }

    public void removeListener(InputListener listener) {
        this.listeners.remove(listener);
    }

    void init(int height) {
        this.height = height;
        this.lastMouseX = this.getMouseX();
        this.lastMouseY = this.getMouseY();
        this.listeners.clear();
    }

    public boolean isKeyDown(int code) {
        return Keyboard.isKeyDown((int)code);
    }

    public int getMouseX() {
        return Mouse.getX();
    }

    public int getMouseY() {
        return this.height - Mouse.getY();
    }

    public boolean isMouseButtonDown(int button) {
        return Mouse.isButtonDown((int)button);
    }

    public int getControllerCount() {
        try {
            this.initControllers();
        }
        catch (SlickException e) {
            throw new RuntimeException("Failed to initialise controllers");
        }
        return controllers.size();
    }

    public boolean isControllerLeft(int controller) {
        if (controller >= this.getControllerCount()) {
            return false;
        }
        if (controller == -1) {
            for (int i = 0; i < controllers.size(); ++i) {
                if (!this.isControllerLeft(i)) continue;
                return true;
            }
            return false;
        }
        return ((Controller)controllers.get(controller)).getXAxisValue() < -0.5f || ((Controller)controllers.get(controller)).getPovX() < -0.5f;
    }

    public boolean isControllerRight(int controller) {
        if (controller >= this.getControllerCount()) {
            return false;
        }
        if (controller == -1) {
            for (int i = 0; i < controllers.size(); ++i) {
                if (!this.isControllerRight(i)) continue;
                return true;
            }
            return false;
        }
        return ((Controller)controllers.get(controller)).getXAxisValue() > 0.5f || ((Controller)controllers.get(controller)).getPovX() > 0.5f;
    }

    public boolean isControllerUp(int controller) {
        if (controller >= this.getControllerCount()) {
            return false;
        }
        if (controller == -1) {
            for (int i = 0; i < controllers.size(); ++i) {
                if (!this.isControllerUp(i)) continue;
                return true;
            }
            return false;
        }
        return ((Controller)controllers.get(controller)).getYAxisValue() < -0.5f || ((Controller)controllers.get(controller)).getPovY() < -0.5f;
    }

    public boolean isControllerDown(int controller) {
        if (controller >= this.getControllerCount()) {
            return false;
        }
        if (controller == -1) {
            for (int i = 0; i < controllers.size(); ++i) {
                if (!this.isControllerDown(i)) continue;
                return true;
            }
            return false;
        }
        return ((Controller)controllers.get(controller)).getYAxisValue() > 0.5f || ((Controller)controllers.get(controller)).getPovY() > 0.5f;
    }

    public boolean isButton1Pressed(int controller) {
        if (controller >= this.getControllerCount()) {
            return false;
        }
        if (controller == -1) {
            for (int i = 0; i < controllers.size(); ++i) {
                if (!this.isButton1Pressed(i)) continue;
                return true;
            }
            return false;
        }
        return ((Controller)controllers.get(controller)).isButtonPressed(0);
    }

    public boolean isButton2Pressed(int controller) {
        if (controller >= this.getControllerCount()) {
            return false;
        }
        if (controller == -1) {
            for (int i = 0; i < controllers.size(); ++i) {
                if (!this.isButton2Pressed(i)) continue;
                return true;
            }
            return false;
        }
        return ((Controller)controllers.get(controller)).isButtonPressed(1);
    }

    public boolean isButton3Pressed(int controller) {
        if (controller >= this.getControllerCount()) {
            return false;
        }
        if (controller == -1) {
            for (int i = 0; i < controllers.size(); ++i) {
                if (!this.isButton3Pressed(i)) continue;
                return true;
            }
            return false;
        }
        return ((Controller)controllers.get(controller)).isButtonPressed(2);
    }

    public void initControllers() throws SlickException {
        if (controllersInited) {
            return;
        }
        controllersInited = true;
        try {
            int i;
            Controllers.create();
            int count = Controllers.getControllerCount();
            for (i = 0; i < count; ++i) {
                Controller controller = Controllers.getController((int)i);
                if (controller.getButtonCount() < 3 || controller.getButtonCount() >= 20) continue;
                controllers.add(controller);
            }
            Log.info("Found " + controllers.size() + " controllers");
            for (i = 0; i < controllers.size(); ++i) {
                Log.info(i + " : " + ((Controller)controllers.get(i)).getName());
            }
        }
        catch (LWJGLException e) {
            if (e.getCause() instanceof ClassNotFoundException) {
                Log.error(e.getCause());
                throw new SlickException("Unable to create controller - no jinput found - add jinput.jar to your classpath");
            }
            Log.error(e);
            throw new SlickException("Unable to create controllers");
        }
    }

    public void consumeEvent() {
        this.consumed = true;
    }

    public void poll(int width, int height) {
        int i;
        block0: while (Keyboard.next()) {
            InputListener listener;
            if (Keyboard.getEventKeyState()) {
                this.keys[Keyboard.getEventKey()] = Keyboard.getEventCharacter();
                this.consumed = false;
                for (i = 0; i < this.listeners.size(); ++i) {
                    listener = (InputListener)this.listeners.get(i);
                    if (!listener.isAcceptingInput()) continue;
                    listener.keyPressed(Keyboard.getEventKey(), Keyboard.getEventCharacter());
                    if (this.consumed) continue block0;
                }
                continue;
            }
            this.consumed = false;
            for (i = 0; i < this.listeners.size(); ++i) {
                listener = (InputListener)this.listeners.get(i);
                if (!listener.isAcceptingInput()) continue;
                listener.keyReleased(Keyboard.getEventKey(), this.keys[Keyboard.getEventKey()]);
                if (this.consumed) continue block0;
            }
        }
        block3: while (Mouse.next()) {
            if (Mouse.getEventButton() >= 0) {
                if (Mouse.getEventButtonState()) {
                    this.consumed = false;
                    for (i = 0; i < this.listeners.size(); ++i) {
                        InputListener listener = (InputListener)this.listeners.get(i);
                        if (!listener.isAcceptingInput()) continue;
                        listener.mousePressed(Mouse.getEventButton(), Mouse.getEventX(), height - Mouse.getEventY());
                        if (this.consumed) continue block3;
                    }
                    continue;
                }
                this.consumed = false;
                for (i = 0; i < this.listeners.size(); ++i) {
                    InputListener listener = (InputListener)this.listeners.get(i);
                    if (!listener.isAcceptingInput()) continue;
                    listener.mouseReleased(Mouse.getEventButton(), Mouse.getEventX(), height - Mouse.getEventY());
                    if (this.consumed) continue block3;
                }
                continue;
            }
            if (Mouse.isGrabbed() && (Mouse.getEventDX() != 0 || Mouse.getEventDY() != 0)) {
                this.consumed = false;
                for (i = 0; i < this.listeners.size(); ++i) {
                    InputListener listener = (InputListener)this.listeners.get(i);
                    if (!listener.isAcceptingInput()) continue;
                    listener.mouseMoved(0, 0, Mouse.getEventDX(), -Mouse.getEventDY());
                    if (this.consumed) break;
                }
            }
            int dwheel = Mouse.getEventDWheel();
            this.wheel += dwheel;
            if (dwheel == 0) continue;
            this.consumed = false;
            for (int i2 = 0; i2 < this.listeners.size(); ++i2) {
                InputListener listener = (InputListener)this.listeners.get(i2);
                if (!listener.isAcceptingInput()) continue;
                listener.mouseWheelMoved(dwheel);
                if (this.consumed) continue block3;
            }
        }
        if (!this.displayActive) {
            this.lastMouseX = this.getMouseX();
            this.lastMouseY = this.getMouseY();
        } else if (this.lastMouseX != this.getMouseX() || this.lastMouseY != this.getMouseY()) {
            this.consumed = false;
            for (i = 0; i < this.listeners.size(); ++i) {
                InputListener listener = (InputListener)this.listeners.get(i);
                if (!listener.isAcceptingInput()) continue;
                listener.mouseMoved(this.lastMouseX, this.lastMouseY, this.getMouseX(), this.getMouseY());
                if (this.consumed) break;
            }
            this.lastMouseX = this.getMouseX();
            this.lastMouseY = this.getMouseY();
        }
        if (controllersInited) {
            for (i = 0; i < this.getControllerCount(); ++i) {
                for (int c = 0; c <= 6; ++c) {
                    if (this.controls[i][c] && !this.isControlPressed(c, i)) {
                        this.controls[i][c] = false;
                        this.fireControlRelease(c, i);
                        continue;
                    }
                    if (this.controls[i][c] || !this.isControlPressed(c, i)) continue;
                    this.controls[i][c] = true;
                    this.fireControlPress(c, i);
                }
            }
        }
        for (i = 0; i < this.listeners.size(); ++i) {
            InputListener listener = (InputListener)this.listeners.get(i);
            listener.inputEnded();
        }
        if (Display.isCreated()) {
            this.displayActive = Display.isActive();
        }
    }

    private void fireControlPress(int index, int controllerIndex) {
        this.consumed = false;
        for (int i = 0; i < this.listeners.size(); ++i) {
            InputListener listener = (InputListener)this.listeners.get(i);
            if (!listener.isAcceptingInput()) continue;
            switch (index) {
                case 0: {
                    listener.controllerLeftPressed(controllerIndex);
                    break;
                }
                case 1: {
                    listener.controllerRightPressed(controllerIndex);
                    break;
                }
                case 2: {
                    listener.controllerUpPressed(controllerIndex);
                    break;
                }
                case 3: {
                    listener.controllerDownPressed(controllerIndex);
                    break;
                }
                case 4: {
                    listener.controllerButtonPressed(controllerIndex, 1);
                    break;
                }
                case 5: {
                    listener.controllerButtonPressed(controllerIndex, 2);
                    break;
                }
                case 6: {
                    listener.controllerButtonPressed(controllerIndex, 3);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown control index");
                }
            }
            if (this.consumed) break;
        }
    }

    private void fireControlRelease(int index, int controllerIndex) {
        this.consumed = false;
        for (int i = 0; i < this.listeners.size(); ++i) {
            InputListener listener = (InputListener)this.listeners.get(i);
            if (!listener.isAcceptingInput()) continue;
            switch (index) {
                case 0: {
                    listener.controllerLeftReleased(controllerIndex);
                    break;
                }
                case 1: {
                    listener.controllerRightReleased(controllerIndex);
                    break;
                }
                case 2: {
                    listener.controllerUpReleased(controllerIndex);
                    break;
                }
                case 3: {
                    listener.controllerDownReleased(controllerIndex);
                    break;
                }
                case 4: {
                    listener.controllerButtonReleased(controllerIndex, 1);
                    break;
                }
                case 5: {
                    listener.controllerButtonReleased(controllerIndex, 2);
                    break;
                }
                case 6: {
                    listener.controllerButtonReleased(controllerIndex, 3);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown control index");
                }
            }
            if (this.consumed) break;
        }
    }

    private boolean isControlPressed(int index, int controllerIndex) {
        switch (index) {
            case 0: {
                return this.isControllerLeft(controllerIndex);
            }
            case 1: {
                return this.isControllerRight(controllerIndex);
            }
            case 2: {
                return this.isControllerUp(controllerIndex);
            }
            case 3: {
                return this.isControllerDown(controllerIndex);
            }
            case 4: {
                return this.isButton1Pressed(controllerIndex);
            }
            case 5: {
                return this.isButton2Pressed(controllerIndex);
            }
            case 6: {
                return this.isButton3Pressed(controllerIndex);
            }
        }
        throw new RuntimeException("Unknown control index");
    }

    private class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        public void write(int b) throws IOException {
        }
    }
}

