/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.openal.AL;
import org.lwjgl.opengl.AWTGLCanvas;
import org.lwjgl.opengl.AWTInputAdapter;
import org.lwjgl.util.applet.LWJGLInstaller;
import org.newdawn.slick.Game;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.openal.SoundStore;
import org.newdawn.slick.opengl.ImageData;
import org.newdawn.slick.opengl.TextureLoader;
import org.newdawn.slick.util.Log;

public class AppletGameContainer
extends Applet {
    private ContainerPanel canvas;
    private Container container;

    public void destroy() {
        super.destroy();
        this.container.stopApplet();
        Log.info("Clear up");
        AWTInputAdapter.destroy();
        Mouse.destroy();
        Keyboard.destroy();
        AL.destroy();
    }

    public void start() {
    }

    public void stop() {
    }

    public void init() {
        try {
            LWJGLInstaller.tempInstall();
        }
        catch (Exception le) {
            le.printStackTrace();
            return;
        }
        this.setLayout(new BorderLayout());
        try {
            Game game = (Game)Class.forName(this.getParameter("game")).newInstance();
            this.container = new Container(game);
            this.canvas = new ContainerPanel(this.container);
            this.canvas.setSize(this.getWidth(), this.getHeight());
            this.add((Component)((Object)this.canvas));
            this.canvas.setFocusable(true);
            this.canvas.requestFocus();
        }
        catch (Exception e) {
            Log.error(e);
            throw new RuntimeException("Unable to create game container");
        }
    }

    public void paint(Graphics g) {
        this.canvas.update(g);
    }

    public GameContainer getContainer() {
        return this.container;
    }

    public class Container
    extends GameContainer {
        public Container(Game game) {
            super(game);
            this.width = AppletGameContainer.this.getWidth();
            this.height = AppletGameContainer.this.getHeight();
        }

        public void initApplet() throws SlickException {
            this.initSystem();
            this.enterOrtho();
            try {
                this.getInput().initControllers();
            }
            catch (SlickException e) {
                Log.info("Controllers not available");
            }
            catch (Throwable e) {
                Log.info("Controllers not available");
            }
            this.game.init(this);
            this.getDelta();
        }

        public void stopApplet() {
            this.running = false;
        }

        public void pollApplet(boolean visible) throws SlickException {
            if (!this.running) {
                return;
            }
            int delta = this.getDelta();
            if (!visible) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            } else {
                this.updateAndRender(delta);
            }
            this.updateFPS();
        }

        public int getScreenHeight() {
            return 0;
        }

        public int getScreenWidth() {
            return 0;
        }

        public boolean hasFocus() {
            return AppletGameContainer.this.hasFocus();
        }

        public void setIcon(String ref) throws SlickException {
        }

        public void setMouseGrabbed(boolean grabbed) {
        }

        public void setMouseCursor(String ref, int hotSpotX, int hotSpotY) throws SlickException {
        }

        public void setIcons(String[] refs) throws SlickException {
        }

        public void setMouseCursor(ImageData data, int hotSpotX, int hotSpotY) throws SlickException {
        }

        public void setMouseCursor(Cursor cursor, int hotSpotX, int hotSpotY) throws SlickException {
        }
    }

    public class ContainerPanel
    extends AWTGLCanvas {
        private Container container;

        public ContainerPanel(Container container) throws LWJGLException {
            this.container = container;
        }

        public void setContainer(Container container) {
            this.container = container;
        }

        protected void initGL() {
            try {
                TextureLoader.get().clear();
                SoundStore.get().clear();
                this.setVSyncEnabled(true);
                AWTInputAdapter.create((AWTGLCanvas)this);
                this.container.initApplet();
            }
            catch (Exception e) {
                Log.error(e);
                this.container.stopApplet();
            }
        }

        protected void paintGL() {
            Mouse.poll();
            Keyboard.poll();
            Controllers.poll();
            try {
                this.container.pollApplet(this.isVisible());
            }
            catch (SlickException e) {
                Log.error(e);
                this.container.stopApplet();
            }
            try {
                this.swapBuffers();
                if (this.isVisible()) {
                    this.repaint();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

