/*
 * Decompiled with CFR 0.152.
 */
package owl.states;

import org.newdawn.slick.Animation;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.state.transition.FadeInTransition;
import org.newdawn.slick.state.transition.FadeOutTransition;
import org.newdawn.slick.state.transition.Transition;

public class MainMenuState
extends BasicGameState {
    public static final int ID = 1;
    public static final int CHOICE_PLAY = 0;
    public static final int CHOICE_INSTRUCTIONS = 1;
    public static final int CHOICE_HISTORY = 2;
    public static final int CHOICE_SCORE = 3;
    public static final int CHOICE_QUIT = 4;
    private Image bg;
    private Image logo;
    private Image play;
    private Image instructions;
    private Image history;
    private Image score;
    private Image quit;
    private GameContainer container;
    private StateBasedGame game;
    private Animation selector;
    private int selectorPos = 250;
    private Sound select;
    private int menuIndex = 0;

    public MainMenuState(StateBasedGame game) {
        this.game = game;
    }

    public int getID() {
        return 1;
    }

    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        this.bg = new Image("images/backgrounds/background.png");
        this.logo = new Image("images/logo.png");
        this.selector = new Animation(new SpriteSheet("images/sprites/walkRight.png", 66, 66), 100);
        this.container = container;
        this.select = new Sound("sounds/select.wav");
        this.play = new Image("images/play_menu.png");
        this.instructions = new Image("images/instructions_menu.png");
        this.history = new Image("images/history_menu.png");
        this.score = new Image("images/highscores_menu.png");
        this.quit = new Image("images/quit_menu.png");
    }

    public void render(GameContainer container, StateBasedGame game, Graphics g) throws SlickException {
        this.bg.draw(-100.0f, -100.0f, 1224.0f, 968.0f);
        this.selector.draw(180, this.selectorPos);
        this.logo.draw(100.0f, 10.0f);
        this.play.draw(250.0f, 250.0f);
        this.instructions.draw(250.0f, 350.0f);
        this.history.draw(250.0f, 450.0f);
        this.score.draw(250.0f, 550.0f);
        this.quit.draw(250.0f, 650.0f);
    }

    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
    }

    public void keyPressed(int key, char c) {
        if (key == 1) {
            this.container.exit();
        } else if (key == 31) {
            this.game.enterState(2, (Transition)new FadeOutTransition(new Color(Color.cyan)), (Transition)new FadeInTransition(new Color(Color.cyan)));
        } else if (key == 200) {
            this.select.play();
            if (this.menuIndex == 0) {
                this.menuIndex = 4;
                this.selectorPos += 400;
            } else {
                --this.menuIndex;
                this.selectorPos -= 100;
            }
        } else if (key == 208) {
            this.select.play();
            if (this.menuIndex == 4) {
                this.menuIndex = 0;
                this.selectorPos -= 400;
            } else {
                ++this.menuIndex;
                this.selectorPos += 100;
            }
        } else if (key == 28) {
            switch (this.menuIndex) {
                case 0: {
                    this.game.enterState(2, (Transition)new FadeOutTransition(new Color(Color.cyan)), (Transition)new FadeInTransition(new Color(Color.cyan)));
                    break;
                }
                case 4: {
                    this.container.exit();
                    break;
                }
                case 3: {
                    this.game.enterState(4, (Transition)new FadeOutTransition(new Color(Color.cyan)), (Transition)new FadeInTransition(new Color(Color.cyan)));
                    break;
                }
                case 1: {
                    this.game.enterState(3, (Transition)new FadeOutTransition(new Color(Color.cyan)), (Transition)new FadeInTransition(new Color(Color.cyan)));
                    break;
                }
                case 2: {
                    this.game.enterState(5, (Transition)new FadeOutTransition(new Color(Color.cyan)), (Transition)new FadeInTransition(new Color(Color.cyan)));
                }
            }
        }
    }
}

