/*
 * Decompiled with CFR 0.152.
 */
package owl.gameobjects;

import java.io.IOException;
import java.util.HashSet;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.particles.ParticleIO;
import org.newdawn.slick.particles.ParticleSystem;
import owl.gameobjects.Cloud;
import owl.gameobjects.Owl;
import owl.utils.OwlParticleIO;

public class CloudMaker {
    private HashSet<Cloud> clouds = new HashSet();
    private HashSet<ParticleSystem> explotions = new HashSet();
    private int cloudpoints;
    private int cloudCount;
    private float gamespeed = -5.0f;
    private Sound dissolve;
    private ParticleSystem rainParticles;
    private ParticleSystem explotion;

    public CloudMaker() {
        try {
            this.rainParticles = ParticleIO.loadConfiguredSystem((String)"particles/raincloud.xml");
            this.explotion = ParticleIO.loadConfiguredSystem((String)"particles/explotion.xml");
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            this.dissolve = new Sound("sounds/dissolve.wav");
        }
        catch (SlickException e) {
            e.printStackTrace();
        }
    }

    public void drawClouds(Graphics g) {
        for (Cloud c : this.clouds) {
            c.draw(g);
        }
        for (ParticleSystem exp : this.explotions) {
            exp.render();
        }
    }

    public void update(int delta) {
        this.cloudpoints += delta;
        if ((float)this.cloudpoints > 2000.0f + this.gamespeed * 5.0f) {
            this.gamespeed -= 0.015f;
            this.clouds.add(new Cloud(this.gamespeed, this.cloudCount / 100, OwlParticleIO.loadConfiguredSystem(this.rainParticles)));
            ++this.cloudCount;
            this.cloudpoints = 0;
        }
        HashSet<Cloud> removeSet = new HashSet<Cloud>();
        for (Cloud c : this.clouds) {
            if (c.getX() < -500.0f) {
                removeSet.add(c);
                continue;
            }
            if (c.isEmpty()) {
                this.dissolve.play(1.0f, 0.3f);
                removeSet.add(c);
                ParticleSystem system = OwlParticleIO.loadConfiguredSystemCopyEmitter(this.explotion);
                system.setPosition(c.getX(), c.getY());
                this.explotions.add(system);
                continue;
            }
            c.update(delta);
        }
        this.clouds.removeAll(removeSet);
        removeSet = null;
        for (ParticleSystem exp : this.explotions) {
            exp.update(delta);
        }
        HashSet<ParticleSystem> remove = new HashSet<ParticleSystem>();
        for (ParticleSystem exp : this.explotions) {
            if (!exp.getEmitter(0).completed()) continue;
            remove.add(exp);
        }
        this.explotions.removeAll(remove);
        remove = null;
    }

    public Cloud checkLandsOnCloud(Owl player) {
        for (Cloud c : this.clouds) {
            if (!c.hasLandedOn(player)) continue;
            return c;
        }
        return null;
    }
}

