float fWidth = 800;
float fHeight = 600;

float4 vColor;	

float fPosX = 0;
float fSizeY = 16;

texture tBase;
sampler smpBase = sampler_state {
    Texture = <tBase>;    
    MipFilter = None; MinFilter = Point; MagFilter = Point;
};

texture tMask;
sampler smpMask = sampler_state {
    Texture = <tMask>;    
    //MipFilter = None; MinFilter = Point; MagFilter = Point;
    MipFilter = None; MinFilter = Linear; MagFilter = Linear;
};


struct SInput {
	float4 pos : POSITION;
        float2 tex : TEXCOORD0;
};

SInput RenderSceneVS( SInput i )
{
	SInput o;
	o.pos = float4( i.pos.x / fWidth * 2 - 1, i.pos.y / fHeight * 2 - 1, i.pos.z, 1 );
	o.tex.y = i.tex.y * 0.5 + 0.3;
	//o.tex = i.tex * 0.5 + 0.3;
	//o.tex = i.tex * 0.9 + 0.05;
	o.tex = i.tex;
	//o.tex.y = i.tex.y;
	//o.tex.x = i.tex.x;
	//o.tex.x += fPosX;
	o.tex.x = fPosX;
	return o; 
}

float4 RenderScenePS( SInput i ) : COLOR
{ 
	float4 col = tex2D( smpBase, i.tex );
	float4 mask = tex2D( smpMask, float2(i.tex.x, i.tex.y * fSizeY) );

	//mask.rgb = mask.a;
	//mask.a = 1;
	//return col;

	//float a = max(mask.a, 0.5);
	//float a = max(mask.a, 0.6);
	float a = mask.a;

	col.rgb = col.rgb * (1 - a) + mask.rgb * a;
	//col.r = mask.a;

	return col;
} 


technique RenderScene {
	pass P0 {          
		VertexShader = compile vs_1_1 RenderSceneVS();
		PixelShader  = compile ps_2_0 RenderScenePS();
		
		ZEnable = False;
		ZWriteEnable = False;
		CullMode = None;

		AlphaBlendEnable = True;
		//AlphaBlendEnable = False;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;
	}
}

	