float fWidth = 800 * 0.01f;
float fHeight = 600 * 0.01f;

float4 vColor;
float4x4 mWorld;

texture tBase;
sampler smpBase = sampler_state {
    Texture = <tBase>;    
    MipFilter = None; MinFilter = Linear; MagFilter = Linear;
};


struct SInput {
	float4 pos : POSITION;
        float2 tex : TEXCOORD0;
};

SInput RenderSceneVS( SInput i )
{
	SInput o;
	float4 pos = mul( i.pos, mWorld );
	//float4 pos = i.pos;
	//pos.x += mWorld._41;
	//pos.z += mWorld._43;
	o.pos = float4( pos.x / fWidth * 2, pos.z / fHeight * 2, -pos.y / 10 + 0.5, 1 );
	o.tex = i.tex;
	return o; 
}

technique RenderScene {
	pass P0 {          
		VertexShader = compile vs_1_1 RenderSceneVS();
		PixelShader  = NULL;
	
		//FillMode = Wireframe;
		//FillMode = Solid;

		ZEnable = False;
		ZWriteEnable = False;		

		//ZEnable = True;
		//ZWriteEnable = True;
		CullMode = None; 

		//AlphaBlendEnable = True;
		AlphaBlendEnable = False;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;		

		//Sampler[0] = (smpBase);

		//TextureFactor = <vColor>;
		TextureFactor = 0x00000000;

		ColorOp[0] = SelectArg2;
		ColorArg2[0] = TFactor;
		AlphaOp[0] = SelectArg2;
		AlphaArg2[0] = TFactor;

		ColorOp[1] = Disable;
		AlphaOp[1] = Disable; 		
	}
}

	