float4x4 mVP;	// View * Projection matrix

float4 vColor;
float4x4 mWorld;

texture tBase;
sampler smpBase = sampler_state {
    Texture = <tBase>;    
    MipFilter = None; MinFilter = Linear; MagFilter = Linear;
};


struct SInput {
	float4 pos : POSITION;
        float2 tex : TEXCOORD0;
};

SInput RenderSceneVS( SInput i )
{
	SInput o;
	float4 pos = mul( i.pos, mWorld );
	o.pos = mul( pos, mVP );
	o.tex = i.tex;
	return o; 
}

technique RenderScene {
	pass P0 {          
		VertexShader = compile vs_1_1 RenderSceneVS();
		PixelShader  = NULL;
	
		//FillMode = Wireframe;
		//FillMode = Solid;
		
		ZEnable = True;
		//ZWriteEnable = True;
		ZWriteEnable = False;
		CullMode = None;

		AlphaBlendEnable = True;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;

		//AlphaTestEnable = True;
		//AlphaFunc = Greater;
		//AlphaRef = 150;		

		Sampler[0] = (smpBase);

		TextureFactor = <vColor>;
		//TextureFactor = 0xffee0000;

		ColorOp[0] = SelectArg2;
		ColorArg2[0] = Texture;
		AlphaOp[0] = SelectArg2;
		AlphaArg2[0] = Texture;

		/*ColorOp[0] = Modulate;
		ColorArg1[0] = Texture;
		ColorArg2[0] = TFactor;
		AlphaOp[0] = Modulate;
		AlphaArg1[0] = Texture;
		AlphaArg2[0] = TFactor;*/


		ColorOp[1] = Disable;
		AlphaOp[1] = Disable; 		
	}
}

	