float4x4 mVP;
float fTx;
float fTy;

texture tBase;
sampler smpBase = sampler_state {
    Texture = <tBase>;    
    MipFilter = None; MinFilter = Linear; MagFilter = Linear;
};


struct SInput {
	float4 pos : POSITION;
};

struct SOutput {
	float4 pos : POSITION;
	float2 tex : TEXCOORD0;
};


SOutput RenderSceneVS( SInput i )
{
	SOutput o;
	float4 pos = i.pos;
	pos.xyz *= 100;

	o.pos = mul( pos, mVP );
	o.tex = o.pos.xy / o.pos.w * 0.5 + 0.5;
	o.tex.y = -o.tex.y;
	return o; 
}

float4 CountoursPS( SOutput i, float tf, float3 diffuse, float factor ) : COLOR
{ 
	float4 col0 = tex2D( smpBase, i.tex );
	float4 col1 = tex2D( smpBase, i.tex + float2(fTx * tf, 0) );
	float4 col2 = tex2D( smpBase, i.tex + float2(0, fTy * tf) );

	//col0.rgb = col0.a;
	//col0.a = 1;
	//return col0;

	float minl = 0.01;
	float maxl = 0.1;

	float l = length(col1 - col0) + length(col2 - col0);

	l = clamp( abs( l ), minl, maxl );
	l = ( l - minl ) / ( maxl - minl );

	float4 col;
	col.a = clamp(col0.a - 0.01, 0, 1);
	//col.rgb = clamp(col0.a - 0.01, 0, 1) * 0.2 + 0.4;

	//col.rgb = float3( 0.84, 0.90, 0.80 ) * 0.6;
	//col.rgb -= l * 0.5;
	//col.rgb += l * 0.5;

	col.rgb = 0.5 + factor * l;

	col.rgb *= diffuse;

	//col.rgb = 0.1;

	return col;

	//return tex2D( smpBase, i.tex ) * float4(1, 0.5, 1, 0.5);

	//return tex2D( smpBase, i.tex );
}

float4 RenderScenePSBook( SOutput i ) : COLOR
{ 
	return CountoursPS( i, 0.5, float3( 0.95, 0.95, 0.85 ), -0.5 );
}


float4 RenderScenePSMeasure( SOutput i ) : COLOR
{ 
	return CountoursPS( i, 1.5, float3( 0.84, 0.90, 0.80 ), 0.5 );
}


technique RenderScene {
	pass P0 {          
		VertexShader = compile vs_1_1 RenderSceneVS();
		//PixelShader  = compile ps_2_0 RenderScenePSMeasure();
		PixelShader  = compile ps_2_0 RenderScenePSBook();	

		//FillMode = Wireframe;		
		FillMode = Solid;		

		ZEnable = False;
		CullMode = CW;

		//AlphaBlendEnable = False;
		AlphaBlendEnable = True;		
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;		
	}
}

	