#include "ZenitShared.fx"

struct SInput {
	float4 pos : POSITION;
	float4 index : BLENDINDICES;
        float3 normal : NORMAL;
};

struct SOutput
{
	float4 pos : POSITION;
	float4 diffuse : COLOR0;
};


SOutput RenderSceneVS( SInput i )
{
	SOutput o;
	
	float3 pos, normal;
	
	gSkinning( i.pos, i.normal, i.index, pos, normal );	
	
	o.pos = mul( float4( pos, 1 ), mVP );
	
	float3 toPos = pos - vCameraPos;

	// fat center
	//float f = abs( dot( normal, normalize( toPos ) ) );
	//o.diffuse.a = pow( f, 4 ) * 0.1;
	
	// transparent center and sides
	float f = abs( dot( normal, normalize( toPos ) ) );
	f = max( 0, 1 - min( abs( f - 0.65 ) * 2, 1 ) );
	o.diffuse.a = pow( f, 3 ) * 0.25;
	o.diffuse.rgb = 0;

	//o.diffuse.a = 1;
	//o.diffuse.rgb = pow( f, 4 ) * 0.15;
	//o.diffuse.rgb = pow( f, 4 ) * 0.3;

	return o;   
}

technique RenderScene {
	pass P0 {          
		VertexShader = compile vs_1_1 RenderSceneVS();
		PixelShader  = NULL;
		
		AlphaBlendEnable = True;
		//SrcBlend = SrcColor;
		//DestBlend = InvSrcColor;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;

		SeparateAlphaBlendEnable = False;
		//SeparateAlphaBlendEnable = True;
		//SrcBlendAlpha = One;
		//DestBlendAlpha = One;
		
		CullMode = None;

		ZEnable = False;
		ZWriteEnable = False;

		ColorOp[0] = SelectArg1;
		ColorArg1[0] = Diffuse;
		AlphaOp[0] = SelectArg1;
		AlphaArg1[0] = Diffuse;
		
		ColorOp[1] = Disable;
		AlphaOp[1] = Disable;
	}
}
