#ifndef __ZENIT_SHARED_FX
#define __ZENIT_SHARED_FX

shared float3 gLightDir = normalize(float3(1.0f, 1.0f, 1.0f));	
shared float4 gLightAmbient = 0.4f;
shared float4 gLightDiffuse = 0.8f;
//shared float4 gLightDiffuse = { 1.0f, 1.0f, 1.0f, 1.0f };			

float4x4 mVP;	// View * Projection matrix
float3 vCameraPos;
int iCull;

static const int MAX_MATRICES = 20;
float4x3 maWorld[MAX_MATRICES] : WORLDMATRIXARRAY;

static inline void gSkinning( 
	float4 iPos, float4 iIndices,
	out float3 oPos )
{
	//int index = iIndices[0];
	int4 indices = D3DCOLORtoUBYTE4( iIndices );
	int index = indices[2]/255;
		
	oPos = mul( iPos, maWorld[index] );   
}


static inline void gSkinning( 
	float4 iPos, float3 iNormal, float4 iIndices,
	out float3 oPos, out float3 oNormal )
{
	//int index = iIndices[0];
	int4 indices = D3DCOLORtoUBYTE4( iIndices );
	int index = indices[2]/255;
		
	oPos = mul( iPos, maWorld[index] );   
	oNormal = normalize( mul( iNormal, (float3x3)maWorld[index] ) ); 
}

static inline void gSkinning( 
	float4 iPos, float3 iNormal, float3 iBinormal, float3 iTangent, float4 iIndices,
	out float3 oPos, out float3 oNormal, out float3 oBinormal, out float3 oTangent )
{
	//int index = iIndices[0];
	int4 indices = D3DCOLORtoUBYTE4( iIndices );
	int index = indices[2]/255;
		
	oPos = mul( iPos, maWorld[index] );   
	oNormal = normalize( mul( iNormal, (float3x3)maWorld[index] ) ); 
	oBinormal = normalize( mul( iBinormal, (float3x3)maWorld[index] ) ); 
	oTangent = normalize( mul( iTangent, (float3x3)maWorld[index] ) ); 

	//oBinormal = iBinormal;
	//oTangent = iTangent;

	//oBinormal = mul( iBinormal, (float3x3)maWorld[index] ); 
	//oTangent = mul( iTangent, (float3x3)maWorld[index] ); 
}

#endif