#include "ZenitShared.fx"

struct SInput {
	float4 pos : POSITION;
	float4 index : BLENDINDICES;
        float3 normal : NORMAL;
};

struct SOutput
{
	float4 pos : POSITION;
	float4 diffuse : COLOR0;
};


SOutput RenderSceneVS( SInput i )
{
	SOutput o;
	
	float3 pos, normal;
	
	gSkinning( i.pos, i.normal, i.index, pos, normal );	
	
	o.pos = mul( float4( pos, 1 ), mVP );
	
	float3 toPos = pos - vCameraPos;	
	o.diffuse.a = max( 1 - abs( dot( normal, normalize( toPos ) ) ) * 1.3, 0.1 );
	//o.diffuse.a = 1;
	o.diffuse.rgb = 1;

	return o;   
}

technique RenderScene {
	pass P0 {          
		VertexShader = compile vs_1_1 RenderSceneVS();
		PixelShader  = NULL;
		
		AlphaBlendEnable = True;
		//AlphaBlendEnable = False;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;

		//SrcBlend = One;
		//DestBlend = One;

		//DestBlend = DestAlpha;

		SeparateAlphaBlendEnable = True;
		SrcBlendAlpha = One;
		DestBlendAlpha = One;
	
		
		CullMode = None;

		ZEnable = False;
		//ZEnable = True;
		ZWriteEnable = False;

		ColorOp[0] = SelectArg1;
		ColorArg1[0] = Diffuse;
		AlphaOp[0] = SelectArg1;
		AlphaArg1[0] = Diffuse;
		
		ColorOp[1] = Disable;
		AlphaOp[1] = Disable;
	}
}
