float fWidth = 800;
float fHeight = 600;

float4 vColor;	

texture tBase;
sampler smpBase = sampler_state {
    Texture = <tBase>;    
    MipFilter = None; MinFilter = Linear; MagFilter = Linear;
};


struct SInput {
	float4 pos : POSITION;
        float2 tex : TEXCOORD0;
};

SInput RenderSceneVS( SInput i )
{
	SInput o;
	o.pos = float4( i.pos.x / fWidth * 2 - 1, i.pos.y / fHeight * 2 - 1, i.pos.z, 1 );
	o.tex = i.tex;
	return o; 
}

float4 RenderScenePS( SInput i ) : COLOR
{ 
	return tex2D( smpBase, i.tex );
} 


technique RenderScene {
	pass P0 {          
		VertexShader = compile vs_1_1 RenderSceneVS();
		PixelShader  = NULL;
		//PixelShader  = compile ps_1_1 RenderScenePS();
		
		ZEnable = False;
		ZWriteEnable = False;
		CullMode = None;

		AlphaBlendEnable = True;
		//AlphaBlendEnable = False;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;		

		Sampler[0] = (smpBase);

		TextureFactor = <vColor>;
		//TextureFactor = 0xffeeeeee;

		//ColorOp[0] = SelectArg1;
		ColorOp[0] = Modulate;
		ColorArg1[0] = Texture;
		ColorArg2[0] = TFactor;
		//AlphaOp[0] = SelectArg1;
		AlphaOp[0] = Modulate;
		AlphaArg1[0] = Texture;
		AlphaArg2[0] = TFactor;

		ColorOp[1] = Disable;
		AlphaOp[1] = Disable; 		
	}
}

	