float4x4 matWorldViewProjection;
float    alphavalue = 1.f;
float    time = 0.f;
float4   ref = {0.f, 0.f, 0.f, 0.f};
texture tex0;

sampler2D Diffuse = 
sampler_state
{
	texture = (tex0);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressU = Wrap; AddressV = Wrap;
};

void vs_main(in float4 ipos : POSITION,
			 in float2 itex : TEXCOORD0,
			 out float4 opos : POSITION, 
			 out float2 otex : TEXCOORD0)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex;
};

float4 ps_main(in float2 tex : TEXCOORD0) : COLOR0
{
	float4 a = tex2D(Diffuse, tex);
	
	
	if(a.r > ref.r)
		a.rgb *= .5f+.5f*sin(tex.y*20.f+time);
	
	a.a *= alphavalue;
	return a;
};

/****************************************************************/



technique Text
{
	pass Texture
	{
		VertexShader = compile vs_2_0 vs_main();
		PixelShader  = compile ps_2_0 ps_main();
	}
}