float4x4 matViewProjection;

texture tex0;
sampler Diffuse = 
sampler_state 
{
	texture = (tex0);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressU = Wrap; AddressV = Wrap;
};

void vs_main(in float4 ipos : POSITION,
			 in float2 itex : TEXCOORD0,
			 out float4 opos : POSITION,
			 out float2 otex : TEXCOORD0)
{
	opos = mul(ipos, matViewProjection);
	otex = itex;
};

float4 ps_main(in float2 tex : TEXCOORD0) : COLOR0
{
	return tex2D(Diffuse, tex);
}

technique Sky
{
	pass p0
	{
		VertexShader = compile vs_2_0 vs_main();
		PixelShader  = compile ps_2_0 ps_main();
	}
}