float4x4 matViewProjection;

void vs_depth(in float4 ipos : POSITION, 
			 out float4 opos : POSITION, 
			 out float depth : TEXCOORD0)
{
	opos = mul(ipos, matViewProjection);
	depth = (opos.z/opos.w);
	depth = length(opos.xyz)/200.f;
};

float4 ps_depth(in float depth : TEXCOORD0) : COLOR0
{
	return depth; 
};

technique Shadow
{
	pass Depth
	{
		VertexShader = compile vs_2_0 vs_depth();
		PixelShader  = compile ps_2_0 ps_depth();
	}
}